<?php
if (!defined('BASEPATH'))
    exit('No direct script access allowed');
class Reports_Marketing extends CI_Controller
{
    var $main_menu_name = "reports_marketing";
    var $sub_menu_name = "";
    public function __construct()
    {
        parent::__construct();
        $this->load->model('Common_Model');
        $this->load->model('Warehouse_Model');
        $this->load->model('Transfer_Model');
        $this->load->model('Sales_Model');
        $this->load->model('Purchases_Model');
        $this->load->model('Report_Model');
        $this->load->model('Product_Damage_Model');
        $this->load->model('Sales_Return_Model');
        $this->load->model('Sequerty_Model');
        $this->load->model('Product_Models');
        $this->load->model('Customer_Model');
        $this->load->model('Expenses_Model');
        $this->load->model('User_Model');
        $this->load->model('Reports_Marketing_Model');
		$this->load->model('Route_Model');
		$this->load->model('In_Type_Model');
		
    }
    public function daily_cash_note()
    {
        $data['main_menu_name']      = $this->main_menu_name;
        $data['sub_menu_name']       = 'daily_cash_note';
		$data['route_list'] = $this->Route_Model->get_all_routes();
        $data['cash_collector_list'] = $this->Reports_Marketing_Model->get_active_cash_collector();
        $this->load->view('marketing_reports/payment_report', $data);
    }
    /*sale report rep wise start*/
    public function sales_note_report()
    {
        $data['main_menu_name'] = $this->main_menu_name;
        $data['sub_menu_name']  = 'sales_note_report';
		$data['route_list'] = $this->Route_Model->get_all_routes();
        $data['sales_rep_list'] = $this->Reports_Marketing_Model->get_active_sales_rep();
        $this->load->view('marketing_reports/rep_sales_note_report', $data);
    }
    public function daily_delivery_summary()
    {
        $data['main_menu_name'] = $this->main_menu_name;
        $data['sub_menu_name']  = 'daily_delivery_summary';
        $data['delivery_list']  = $this->Reports_Marketing_Model->get_active_delivery();
        $this->load->view('marketing_reports/delivery_summary', $data);
    }
	 public function sales_item_report()
    {
        $data['main_menu_name'] = $this->main_menu_name;
        $data['sub_menu_name']  = 'sales_item_report';
        $data['sales_rep_list'] = $this->Reports_Marketing_Model->get_active_sales_rep();
        $this->load->view('marketing_reports/rep_sales_item_report', $data);
    }
    public function get_delivery_sale_list_by_date()
    {
        $deliver_id           = $this->input->get('rep_id');
        $from_date            = $this->input->get('from_date');
        //$to_date=$this->input->get('to_date');
        $invoice_product_list = $this->Reports_Marketing_Model->get_invoice_list_product($deliver_id, $from_date);
        $json_data            = array();
        foreach ($invoice_product_list as $row) {
            $nested_data        = array();
            $sold_qty_and_value = $this->Reports_Marketing_Model->get_sold_qty_and_sub_total($row['product_id'], $deliver_id, $from_date);
            $nested_data[]      = $row['product_code'];
            $nested_data[]      = $row['product_name'];
            $nested_data[]      = $sold_qty_and_value['quantity'];
            $nested_data[]      = $sold_qty_and_value['gross_total'];
            $json_data[]        = $nested_data;
        }
        echo json_encode(array(
            'data' => $json_data
        ));
    }
    public function get_delivery_return_list_by_date()
    {
        $deliver_id          = $this->input->get('rep_id');
        $from_date           = $this->input->get('from_date');
        //$to_date=$this->input->get('to_date');
        $return_product_list = $this->Reports_Marketing_Model->get_return_list_product($deliver_id, $from_date);
        $json_data           = array();
        foreach ($return_product_list as $row) {
            $nested_data   = array();
            $nested_data[] = $row['product_code'];
            $nested_data[] = $row['product_name'];
            $nested_data[] = $row['return_qty'];
            $nested_data[] = $row['return_date_time'];
            $json_data[]   = $nested_data;
        }
        echo json_encode(array(
            'data' => $json_data
        ));
    }
    //----------------------------------------------------------------------------------
    public function get_sales_note_report_rep_id_and_date()
    {
        $sale_rep_id       = $this->input->get('rep_id');
        $from_date         = $this->input->get('from_date');
        $to_date           = $this->input->get('to_date');
        $invoice_item_list = $this->Reports_Marketing_Model->get_sales_note_report_rep_id_and_date($sale_rep_id, $from_date, $to_date);
        $json_data         = array();
        foreach ($invoice_item_list as $row) {
            $nested_data    = array();
            $date           = date_create($row['sale_datetime']);
            $converted_date = date_format($date, "Y-m-d");
            $nested_data[]  = $row['product_code'];
            $nested_data[]  = $row['product_name'];
            $nested_data[]  = 0;
            $nested_data[]  = 0;
            $json_data[]    = $nested_data;
        }
        echo json_encode(array(
            'data' => $json_data
        ));
    }
    public function get_sales_note_report_rep_id_and_date_invoice_wise()
    {
        $sale_rep_id        = $this->input->get('rep_id');
        $from_date          = $this->input->get('from_date');
        $to_date            = $this->input->get('to_date');
        $invoice_item_list2 = $this->Reports_Marketing_Model->get_sales_note_report_rep_id_and_date_invoice_wise($sale_rep_id, $from_date, $to_date);
        $json_data          = array();
        foreach ($invoice_item_list2 as $row) {
            $nested_data = array();
            if (isset($row['sale_total']) and isset($row['sale_pymnt_amount'])) {
                $to_be_paid = $row['sale_total'] - $row['sale_pymnt_amount'];
            } else {
                $to_be_paid = 0;
            }
            if ($to_be_paid == 0) {
                $lable = '<span class="label label-warning">Pending</span>';
            } else {
                if ($to_be_paid > 0) {
                    $lable = '<span class="label label-info">Partial</span>';
                }
            }
            $date           = date_create($row['sale_datetime']);
            $converted_date = date_format($date, "Y-m-d");
            $nested_data[]  = $converted_date;
            $nested_data[]  = $row['card_ref_number'] . " / " . $row['sale_reference_no'];
            $nested_data[]  = $row['cus_name'];
            $nested_data[]  = $row['sale_total'];
            $nested_data[]  = $row['totat_down_payment'];
            $nested_data[]  = $row['sale_pymnt_amount'];
            $nested_data[]  = $to_be_paid;
            $nested_data[]  = $row['sale_pymnt_paying_by'];
            $nested_data[]  = $lable;
            $json_data[]    = $nested_data;
        }
        echo json_encode(array(
            'data' => $json_data
        ));
    }
    public function get_sale_by_rep_id_and_date_summary()
    {
        $sale_rep_id        = $this->input->get('rep_id');
        $from_date          = $this->input->get('from_date');
        $to_date            = $this->input->get('to_date');
        $invoice_item_list3 = $this->Reports_Marketing_Model->get_sale_by_rep_id_and_date_summary($sale_rep_id, $from_date, $to_date);
        $json_data          = array();
        $json_data          = $invoice_item_list3;
        echo json_encode(array(
            'data' => $json_data
        ));
    }
    public function get_sale_by_rep_id_and_date_summary_cash()
    {
        $sale_rep_id        = $this->input->get('rep_id');
        $from_date          = $this->input->get('from_date');
        $to_date            = $this->input->get('to_date');
        $invoice_item_list3 = $this->Reports_Marketing_Model->get_sale_by_rep_id_and_date_summary_cash($sale_rep_id, $from_date, $to_date);
        $json_data          = array();
        $json_data          = $invoice_item_list3;
        echo json_encode(array(
            'data' => $json_data
        ));
    }
    public function get_sale_by_rep_id_and_date_summary_cheque()
    {
        $sale_rep_id        = $this->input->get('rep_id');
        $from_date          = $this->input->get('from_date');
        $to_date            = $this->input->get('to_date');
        $invoice_item_list3 = $this->Reports_Marketing_Model->get_sale_by_rep_id_and_date_summary_cheque($sale_rep_id, $from_date, $to_date);
        $json_data          = array();
        $json_data          = $invoice_item_list3;
        echo json_encode(array(
            'data' => $json_data
        ));
    }
    public function get_sale_by_rep_id_and_date_summary_total()
    {
        $sale_rep_id        = $this->input->get('rep_id');
        $from_date          = $this->input->get('from_date');
        $to_date            = $this->input->get('to_date');
        $invoice_item_list3 = $this->Reports_Marketing_Model->get_sale_by_rep_id_and_date_summary_total($sale_rep_id, $from_date, $to_date);
        $json_data          = array();
        $json_data          = $invoice_item_list3;
        echo json_encode(array(
            'data' => $json_data
        ));
    }
    /*sale report rep wise end*/
    public function daily_sales_note()
    {
        $data['main_menu_name'] = $this->main_menu_name;
        $data['sub_menu_name']  = 'daily_sales_note';
        $data['sales_rep_list'] = $this->Reports_Marketing_Model->get_active_sales_rep();
        $this->load->view('marketing_reports/rep_deaily_sales_note', $data);
    }
    public function get_daily_sale_by_rep_id_and_date_summary_print()
    {
        $sale_rep_id        = $this->input->get('rep_id');
        $date               = $this->input->get('date');
        $summary            = $this->Reports_Marketing_Model->get_daily_sale_by_rep_id_and_date_summary($sale_rep_id, $date);
        $cash_value         = $this->Reports_Marketing_Model->get_daily_sale_by_rep_id_and_date_summary_cash($sale_rep_id, $date);
        $cheque             = $this->Reports_Marketing_Model->get_daily_sale_by_rep_id_and_date_summary_cheque($sale_rep_id, $date);
        $invoice_item_list  = $this->Reports_Marketing_Model->get_daily_sale_by_rep_id_and_date($sale_rep_id, $date);
        $data['sales_list'] = $invoice_item_list;
        $data['summary']    = $summary;
        $data['cash_value'] = $cash_value;
        $data['cheque']     = $cheque;
        $this->load->view('models/print_daily_rep_summary', $data);
    }
    public function get_daily_cash_by_collector_id_and_date_summary_print()
    {
        $collector_id      = $this->input->get('collector_id');
        $date              = $this->input->get('date');
        $summary           = $this->Reports_Marketing_Model->get_daily_cash_by_collector_and_date_summary($collector_id, $date);
        $cash_item_list    = $this->Reports_Marketing_Model->get_daily_cash_by_collector_id_and_date($collector_id, $date);
        $data['cash_list'] = $cash_item_list;
        $data['summary']   = $summary;
        $this->load->view('models/print_daily_cash_collector_summary', $data);
    }
    public function get_daily_cash_by_collector_and_date_summary()
    {
        $collector_id    = $this->input->get('collector_id');
        $date            = $this->input->get('date');
        $collected_cash2 = $this->Reports_Marketing_Model->get_daily_cash_by_collector_and_date_summary($collector_id, $date);
        $json_data       = array();
        $json_data       = $collected_cash2;
        echo json_encode(array(
            'data' => $json_data
        ));
    }
    public function get_daily_sale_by_rep_id_and_date_summary()
    {
        $sale_rep_id        = $this->input->get('rep_id');
        $date               = $this->input->get('date');
        $invoice_item_list3 = $this->Reports_Marketing_Model->get_daily_sale_by_rep_id_and_date_summary($sale_rep_id, $date);
        $json_data          = array();
        $json_data          = $invoice_item_list3;
        echo json_encode(array(
            'data' => $json_data
        ));
    }
    public function get_daily_sale_by_rep_id_and_date_summary_cash()
    {
        $sale_rep_id        = $this->input->get('rep_id');
        $date               = $this->input->get('date');
        $invoice_item_list3 = $this->Reports_Marketing_Model->get_daily_sale_by_rep_id_and_date_summary_cash($sale_rep_id, $date);
        $json_data          = array();
        $json_data          = $invoice_item_list3;
        echo json_encode(array(
            'data' => $json_data
        ));
    }
    public function get_daily_sale_by_rep_id_and_date_summary_cheque()
    {
        $sale_rep_id        = $this->input->get('rep_id');
        $date               = $this->input->get('date');
        $invoice_item_list3 = $this->Reports_Marketing_Model->get_daily_sale_by_rep_id_and_date_summary_cheque($sale_rep_id, $date);
        $json_data          = array();
        $json_data          = $invoice_item_list3;
        echo json_encode(array(
            'data' => $json_data
        ));
    }
    public function get_daily_sale_by_rep_id_and_date_final()
    {
        $sale_rep_id        = $this->input->get('rep_id');
        $date               = $this->input->get('date');
        $invoice_item_list2 = $this->Reports_Marketing_Model->get_daily_sale_by_rep_id_and_date_final($sale_rep_id, $date);
        $json_data          = array();
        foreach ($invoice_item_list2 as $row) {
            $nested_data    = array();
            $payment_amount = 0;
            if (isset($row['sale_pymnt_amount'])) {
                $to_be_paid     = $row['sale_total'] - $row['sale_pymnt_amount'];
                $payment_amount = $row['sale_pymnt_amount'];
            } else {
                $to_be_paid = $row['sale_total'];
            }
            $nested_data[] = $row['card_ref_number'] . " / " . $row['sale_reference_no'];
            $nested_data[] = $row['cus_name'];
            $nested_data[] = $row['sale_total'];
            $nested_data[] = $payment_amount;
            $nested_data[] = $to_be_paid;
            $nested_data[] = $row['sale_pymnt_paying_by'];
            $json_data[]   = $nested_data;
        }
        echo json_encode(array(
            'data' => $json_data
        ));
    }
    public function get_daily_sale_by_rep_id_and_date()
    {
        $sale_rep_id       = $this->input->get('rep_id');
        $date              = $this->input->get('date');
        $invoice_item_list = $this->Reports_Marketing_Model->get_daily_sale_by_rep_id_and_date($sale_rep_id, $date);
        $json_data         = array();
        foreach ($invoice_item_list as $row) {
            $nested_data   = array();
            $nested_data[] = $row['card_ref_number'] . " / " . $row['sale_reference_no'];
            $nested_data[] = $row['product_name'];
            $nested_data[] = $row['quantity'];
            $nested_data[] = $row['gross_total'];
            $nested_data[] = $row['cus_name'] . " (" . $row['cus_code'] . ")";
            $json_data[]   = $nested_data;
        }
        echo json_encode(array(
            'data' => $json_data
        ));
    }
    function get_daily_sale_by_rep_id_and_date_sales_note_report()
    {
        $sale_rep_id       = $this->input->get('rep_id');
        $date              = $this->input->get('date');
        $to_date           = $this->input->get('to_date');
        $invoice_item_list = $this->Reports_Marketing_Model->get_daily_sale_by_rep_id_and_date_sales_note_report($sale_rep_id, $date, $to_date);
        $json_data         = array();
        foreach ($invoice_item_list as $row) {
            $nested_data = array();
            if (isset($row['gross_total']) and isset($row['sale_pymnt_amount'])) {
                $to_be_paid = $row['gross_total'] - $row['sale_pymnt_amount'];
            } else {
                $to_be_paid = 0;
            }
            if ($to_be_paid == 0) {
                $lable = '<span class="label label-warning">Pending</span>';
            } else {
                if ($to_be_paid > 0) {
                    $lable = '<span class="label label-info">Partial</span>';
                }
            }            
            $nested_data[] = $row['sale_datetime'];
            $nested_data[] = $row['card_ref_number'] . " / " . $row['sale_reference_no'];
            $nested_data[] = $row['product_name'];
            $nested_data[] = $row['quantity'];
            $nested_data[] = $row['gross_total'];            
            $nested_data[] = $lable;
            $json_data[]   = $nested_data;
        }
        echo json_encode(array(
            'data' => $json_data
        ));
    }
    public function get_daily_cash_by_collector_id_and_date()
    {
        $collector_id = $this->input->get('collector_id');
        $date         = $this->input->get('date');
        $cash_list    = $this->Reports_Marketing_Model->get_daily_cash_by_collector_id_and_date($collector_id, $date);
        //print_r($cash_list);
        $json_data    = array();
        foreach ($cash_list as $row) {
            $nested_data   = array();
            $nested_data[] = $row['card_ref_number'] . " / " . $row['sale_reference_no'];
            $nested_data[] = $row['sale_pymnt_amount'];
            $json_data[]   = $nested_data;
        }
        echo json_encode(array(
            'data' => $json_data
        ));
    }
	
	 public function customer_outstanding_report()
    {
        $data['main_menu_name']      = $this->main_menu_name;
        $data['sub_menu_name']       = 'customer_outstanding_report';
        $data['route_list'] = $this->Route_Model->get_all_routes();
        $this->load->view('marketing_reports/customer_outstanding_report', $data);
    }
	 public function get_customer_outstanding_list()
    {
	 	$route_id        = $this->input->get('route_id');
		$start=$this->input->get('start');
		$length=$this->input->get('length');
		$search=$this->input->get('search');
		$totalData = $this->Reports_Marketing_Model->get_all_customers_by_route_id($route_id,"","",$search);
		$totalFiltered=$totalData;
        $customer_list = $this->Reports_Marketing_Model->get_all_customers_by_route_id($route_id,$start,$length,$search);
        $json_data          = array();
        foreach ($customer_list as $row) {

            $total_outstanding_amount=0;
           		
			$customer_id=$row['cus_id'];
			$sale_total = $this->Reports_Marketing_Model->get_all_sale_total_by_customer_id($customer_id);
			$sale_paid = $this->Reports_Marketing_Model->get_all_paid_total_by_customer_id($customer_id);		
            $sale_list = $this->Reports_Marketing_Model->get_all_sale_list_by_customer_id($customer_id);
            $return_balance =0; //$this->Reports_Marketing_Model->get_cheque_return_balance_by_customer_id($customer_id);
            $return_cheque_list = $this->Reports_Marketing_Model->get_all_cheque_return_list_by_customer_id($customer_id);
            $over_cheq_list = $this->Reports_Marketing_Model->get_uncomplte_multiple_payment($customer_id);
            $cus_payment_balance=0;
            foreach($over_cheq_list as $ovc)
            {
                $id=$ovc['smp_id'];
                $sale_paid=$this->Reports_Marketing_Model->get_total_sale_paid_by_smp_id($id);		
                $return_paid=$this->Reports_Marketing_Model->get_total_cheque_return_paid_by_smp_id($id);
                $sale_balance=$ovc['smp_amount']-$return_paid-$sale_paid;
                $cus_payment_balance+=$sale_balance;
            }
            
			
			$table_header='<table class="table table-bordered table-condensed table-hover table-striped dataTable" id="outstanding_table">
			<thead><th class="col-sm-1">INV No</th><th class="col-sm-1">REF.NO</th><th class="col-sm-1">Inv Date</th><th class="col-sm-1">Due Date</th><th class="col-sm-1">Sale Type</th><th class="col-sm-1">Sale Total</th><th class="col-sm-1">Sale Paid</th><th class="col-sm-2">outstanding</th></thead><tbody>';       
			$table_foorter='</tbody></table>';			
			$table_body="";
			$return_full_amount=0;
			$count=0;
			foreach($sale_list as $key){
				$converted_sale_date   = date('Y-m-d', strtotime($key['sale_datetime']));
				$s_paid = $this->Reports_Marketing_Model->get_all_paid_total_by_sale_id($key['sale_id']);
				
				$return_tot=$this->Sales_Return_Model->get_relevant_return_by_sale_id($key['sale_id']);		
		if(isset($return_tot['sl_rtn_total']))
		{
		$return_tot_amt=$return_tot['sl_rtn_total'];
		}
		else
		{
			$return_tot_amt=0;
		}		
		if(isset($return_tot['sls_rtn_total_paid']))
		{
		$return_tot_paid=$return_tot['sls_rtn_total_paid'];
		}
		else
		{
			$return_tot_paid=0;
		}
				
				
				$sale_total_full=$key['sale_total']-$return_tot_amt;
                $s_outstanding=($key['sale_total']-$return_tot_amt)-($s_paid);
                
                $total_outstanding_amount+=$s_outstanding;
				$count=1;
				$table_row='<tr><td>'.$key['sale_reference_no'].'</td>'.'<td>'.$key['card_ref_number'].'</td>'.'<td>'.$converted_sale_date.'</td>'.'<td>'.$key['due_date'].'</td>'.'<td><span class="'.$key['class_name_report'].'">'.$key['invoice_type_name'].'</span></td>'.'<td>'.$sale_total_full.'</td><td>'.$s_paid.'</td><td>'.$s_outstanding.'</td></tr>';
			$table_body.=$table_row;
			$return_full_amount+=$return_tot_amt;
			}			
			$table="";
			$table=$table_header.$table_body.$table_foorter;			
			
            if($count==0){$table="";}
            
            $table_header_return='<table class="table_rtn table-bordered table-condensed table-hover table-striped dataTable" id="return_table">
			<thead><th class="col-sm-1">Cheque No</th><th class="col-sm-1">Cheque Date</th><th class="col-sm-1">Return Date</th><th class="col-sm-1">Due Date</th><th class="col-sm-1">Cheque value</th><th class="col-sm-1">Panalty</th><th class="col-sm-2">Cheque Return Balance </th></thead><tbody>';       
			$table_foorter_retun='</tbody></table>';			
			$table_body_return="";
			$return_count=0;
			foreach($return_cheque_list as $key){
                $retun_paid_amount=$this->Reports_Marketing_Model->get_cheque_reurn_paid_amount($key['ret_pay_id']);
                $chequ_return_balance_amount=$key['total_return_amount']-$retun_paid_amount;
                $che_re_due_date=date('Y-m-d', strtotime($key['return_date']. ' + 10 day'));
                $return_count=1;
				$table_row='<tr><td>'.$key['payment_ref_no'].'</td>'.'<td>'.$key['payment_date'].'</td>'.'<td>'.$key['return_date'].'</td>'.'<td>'.$che_re_due_date.'</td>'.'<td>'.$key['smp_amount'].'</td><td>'.$key['panalty_charge'].'</td><td>'.$chequ_return_balance_amount.'</td></tr>';           
                $table_body_return.=$table_row;
            }           
            $table_retun=$table_header_return.$table_body_return.$table_foorter_retun;            
            if($return_count==0){$table_retun="";}
            $nested_data = array();           
     		$nested_data[]  = $row['cus_code'];
            $nested_data[]  = $row['cus_name'];
            $nested_data[]  = $row['cus_address'];
            $nested_data[]  = $cus_payment_balance;
            $nested_data[]  = $table.$table_retun;
            $nested_data[]  =$total_outstanding_amount-$cus_payment_balance; //($sale_total-$return_full_amount)-$sale_paid+$return_balance;
            $json_data[]    = $nested_data;
        }
        echo json_encode(array(
			"recordsTotal"    => intval( $totalData ),  
			"recordsFiltered" => intval( $totalFiltered ),
            'data' => $json_data
        ));
    }
	
	function get_customer_outstanding_summary(){
		$route_id=$this->input->post('route_id');
		$sale_total = $this->Reports_Marketing_Model->get_all_sale_total_by_route_id($route_id);
        $sale_paid = $this->Reports_Marketing_Model->get_all_paid_total_by_route_id($route_id);	
        $sale_return = $this->Reports_Marketing_Model->get_all_sale_returns_total_by_route_id($route_id);	
		
		 echo json_encode(array(
			"sale_total"    => $sale_total,  
			"sale_return"    =>$sale_return,  
			"sale_paid" => $sale_paid,
            "outstanding" => ($sale_total-$sale_return)-$sale_paid
        ));
		
	}
	
	 public function get_sale_item_report()
    {
        $from_date            = $this->input->get('from_date');
        $to_date			  =$this->input->get('to_date');
		$rep_id			  =$this->input->get('rep_id');
		$from_date=date('Y-m-d', strtotime($from_date));
		$to_date=date('Y-m-d', strtotime($to_date. ' +1 day'));	
		
        $invoice_product_list = $this->Reports_Marketing_Model->get_invoice_list_product_item($from_date,$to_date,$rep_id);
        $json_data            = array();
		
        foreach ($invoice_product_list as $row) {
            $nested_data        = array();
            $sold_qty_and_value = $this->Reports_Marketing_Model->get_sold_qty_and_sub_total_by_period($from_date,$to_date,$row['product_id'],$rep_id);
            $nested_data[]      = $row['product_code'];
            $nested_data[]      = $row['product_name'];
            $nested_data[]      = $sold_qty_and_value['quantity'];
            $nested_data[]      = $sold_qty_and_value['net_total'];
            $json_data[]        = $nested_data;
        }
        echo json_encode(array(
            'data' => $json_data
        ));
    }
	
	 public function get_sale_item_summary_report()
    {
        $from_date            = $this->input->post('from_date');
        $to_date			  =$this->input->post('to_date');
		$rep_id			  =$this->input->post('rep_id');
		
		$from_date=date('Y-m-d', strtotime($from_date));
		$to_date=date('Y-m-d', strtotime($to_date. ' +1 day'));
		
        $invoice_product_summary = $this->Reports_Marketing_Model->get_sold_qty_and_sub_total_by_period_summary($from_date,$to_date,$rep_id);
       
        echo json_encode(array(
            'net_total' => $invoice_product_summary['net_total'],
			'quantity' => $invoice_product_summary['quantity'],
        ));
    }
	
	
	
	
	 public function get_sale_report()
    {
        $from_date            = $this->input->get('from_date');
        $to_date			  =$this->input->get('to_date');
		$rep_id			  =$this->input->get('rep_id');
		$route_id			  =$this->input->get('route_id');
		$from_date=date('Y-m-d', strtotime($from_date));
		$to_date=date('Y-m-d', strtotime($to_date. ' +1 day'));	
		
        $invoice_product_list = $this->Reports_Marketing_Model->get_invoice_list($from_date,$to_date,$rep_id,$route_id);
        $json_data            = array();
		
        foreach ($invoice_product_list as $row) {
            $nested_data        = array();

            $return_tot=$this->Sales_Return_Model->get_relevant_return_by_sale_id($row['sale_id']);		
		if(isset($return_tot['sl_rtn_total']))
		{
        $return_tot_amt=$return_tot['sl_rtn_total'];
        $return_cost_amt=$return_tot['cost_total'];
		}
		else
		{
            $return_tot_amt=0;
            $return_cost_amt=0;
		}		
			
			$profit=($row['sale_total']-$return_tot_amt)-($row['cost_total']-$return_cost_amt);
            //$sold_qty_and_value = $this->Reports_Marketing_Model->get_sold_qty_and_sub_total_by_period($from_date,$to_date,$row['product_id'],$rep_id);
            $nested_data[]      = $row['sale_datetime'];
            $nested_data[]      = $row['card_ref_number']."/".$row['sale_reference_no'];
            $nested_data[]      = $row['cus_name'];	
            if($this->session->userdata('ss_group_id')==1||$this->session->userdata('ss_group_id')==2){ 		
            $nested_data[]      = $row['sale_inv_gross_total'];            
            $nested_data[]      = $row['total_default_discount_value'];		
            }else{$nested_data[] = ""; $nested_data[]  = "";}	
            $nested_data[]      = $row['sale_total']-$return_tot_amt;
            if($this->session->userdata('ss_group_id')==1||$this->session->userdata('ss_group_id')==2){ 
			$nested_data[]      = $row['cost_total']-$return_cost_amt;
			$nested_data[]      = number_format($profit, 2, '.', '');;
            $nested_data[]      = number_format(($profit/($row['sale_total']-$return_tot_amt))*100, 2, '.', ',')."%";
            }else{$nested_data[]      = "";$nested_data[] = ""; $nested_data[]  = "";}	
            $json_data[]        = $nested_data;
        }
        echo json_encode(array(
            'data' => $json_data
        ));
    }
	
	
	
	 public function get_sale_report_summary()
    {
        $from_date        = $this->input->post('from_date');
        $to_date		  =$this->input->post('to_date');
		$rep_id			  =$this->input->post('rep_id');
		$route_id			  =$this->input->post('route_id');
		$from_date		  =date('Y-m-d', strtotime($from_date));
		$to_date=date('Y-m-d', strtotime($to_date. ' +1 day'));
		
        $invoice_product_summary = $this->Reports_Marketing_Model->get_invoice_summary($from_date,$to_date,$rep_id,$route_id);
       
		if(isset($invoice_product_summary['sale_inv_gross_total'])){
		$profit=$invoice_product_summary['sale_total']-$invoice_product_summary['cost_total'];
		
		$profitprecentage=number_format(($profit/$invoice_product_summary['sale_total'])*100, 2, '.', ',');
		}
		if(isset($invoice_product_summary['sale_inv_gross_total'])){
			echo json_encode(array(
            'total_default_discount_value' => $invoice_product_summary['total_default_discount_value'],
			'sale_inv_gross_total' => $invoice_product_summary['sale_inv_gross_total'],
			'sale_total' => $invoice_product_summary['sale_total'],
			'cost_total' => $invoice_product_summary['cost_total'],
			'profit' => $profit." ( ".$profitprecentage."% )",
        ));
		}
		else{
			echo json_encode(array(
            'total_default_discount_value' => "--",
			'sale_inv_gross_total' => "--",
			'sale_total' => "--",
			'cost_total' => "--",
			'profit' => "--",
        ));
		
		
		}
    }
	
	
	 public function get_payment_report()
    {
        $from_date            = $this->input->get('from_date');
        $to_date			  =$this->input->get('to_date');
		$route_id			  =$this->input->get('route_id');
		$from_date=date('Y-m-d', strtotime($from_date));
		$to_date=date('Y-m-d', strtotime($to_date. ' +1 day'));	
		
        $invoice_product_list = $this->Reports_Marketing_Model->get_payment_list($from_date,$to_date,$route_id);
        $json_data            = array();
		
        foreach ($invoice_product_list as $row) {
            $nested_data        = array();
            //$sold_qty_and_value = $this->Reports_Marketing_Model->get_sold_qty_and_sub_total_by_period($from_date,$to_date,$row['product_id'],$rep_id);
            $nested_data[]      = $row['sale_pymnt_date_time'];
			$nested_data[]      = $row['sale_pymnt_paying_by'];
            $nested_data[]      = $row['card_ref_number']."/".$row['sale_reference_no'];
            $nested_data[]      = $row['sale_pymnt_ref_no'].$row['sale_pymnt_cheque_no'];			
			$nested_data[]      = $row['cus_name'];
			$nested_data[]      = $row['sale_pymnt_amount'];			
          
            $json_data[]        = $nested_data;
        }
        echo json_encode(array(
            'data' => $json_data
        ));
    }
	
	 public function get_payment_summary_report()
    {
        $from_date            = $this->input->post('from_date');
        $to_date			  =$this->input->post('to_date');
		$route_id			  =$this->input->post('route_id');
		$from_date=date('Y-m-d', strtotime($from_date));
		$to_date=date('Y-m-d', strtotime($to_date. ' +1 day'));	
		$to_dateexp=date('Y-m-d', strtotime($to_date));
        $cash = $this->Reports_Marketing_Model->get_payment_cash_summary($from_date,$to_date,$route_id);
		$cheque = $this->Reports_Marketing_Model->get_payment_cheque_summary($from_date,$to_date,$route_id);
		$expencess = $this->Reports_Marketing_Model->get_expensess_summary($from_date,$to_dateexp);
        
		$cash_amount=0;
		if(isset($cash['sale_pymnt_amount'])){$cash_amount=$cash['sale_pymnt_amount'];}
		$cheque_amount=0;
		if(isset($cheque['sale_pymnt_amount'])){$cheque_amount=$cheque['sale_pymnt_amount'];}
		$expencess_amount=0;
		if(isset($expencess['acctrnss_amount'])){$expencess_amount=$expencess['acctrnss_amount'];}
		
		
		echo json_encode(array(
            'cash_total' => $cash_amount,
			'cheque_total' => $cheque_amount,
			'payment_total' => $cash_amount+$cheque_amount,
			'expencess_total' => $expencess_amount,
			'payment_balance' => ($cash_amount+$cheque_amount)-$expencess_amount,
			
        ));
    }
	
	 public function cus_order_report()
    {
        $data['main_menu_name']      = $this->main_menu_name;
        $data['sub_menu_name']       = 'cus_order_report';
		$data['route_list'] 		 = $this->Route_Model->get_all_routes();
        $data['cus_list'] 			 = $this->Customer_Model->get_all_customers();
		$data['type_list'] 			 = $this->In_Type_Model->get_active_in_types();		
        $this->load->view('marketing_reports/cus_order_report', $data);
    }
	 public function get_customer_order_report()
    {
        $from_date            = $this->input->get('from_date');
        $to_date			  =$this->input->get('to_date');
		$route_id			  =$this->input->get('route_id');
		$cus_id			  =$this->input->get('cus_id');
		$status_id		  =$this->input->get('status_id');
		$type_id		  =$this->input->get('type_id');
		
		$from_date=date('Y-m-d', strtotime($from_date));
		$to_date=date('Y-m-d', strtotime($to_date));	
		
        $invoice_product_list = $this->Reports_Marketing_Model->get_cus_order_list($from_date,$to_date,$route_id,$cus_id,$status_id,$type_id);
        $json_data            = array();
		
        foreach ($invoice_product_list as $row) {
            $nested_data        = array();
			$loaded="To Be Loading";
			$status="Pending";
			if($row['invoiced_status']==1){$status="Invoiced";}
			if($row['status']==1){$loaded="Loaded";}
            //$sold_qty_and_value = $this->Reports_Marketing_Model->get_sold_qty_and_sub_total_by_period($from_date,$to_date,$row['product_id'],$rep_id);
            $nested_data[]      = $row['customer_order_date'];
			$nested_data[]      = $row['invoice_type_name'];
            $nested_data[]      = $row['cus_order_ref_no'];
			$nested_data[]      = $row['cus_name'];
            $nested_data[]      = $loaded;
			$nested_data[]      = $status;		
			$nested_data[]      = $row['approval_status'];	
			$nested_data[]      = $row['credit_approval_status'];		
			
			$nested_data[]      = $row['net_amount'];			
          
            $json_data[]        = $nested_data;
        }
        echo json_encode(array(
            'data' => $json_data
        ));
    }
	
	public function get_order_summary_report()
    {
        $from_date            = $this->input->post('from_date');
        $to_date			  =$this->input->post('to_date');
		$route_id			  =$this->input->post('route_id');
		$cus_id			  =$this->input->post('cus_id');
		$status_id		  =$this->input->post('status_id');
		$type_id		  =$this->input->post('type_id');
		
		$from_date=date('Y-m-d', strtotime($from_date));
		$to_date=date('Y-m-d', strtotime($to_date));	
		
		
		if(!$status_id||$status_id=='pending'){
		$order_p = $this->Reports_Marketing_Model->get_cus_order_summary($from_date,$to_date,$route_id,$cus_id,'pending',$type_id);	
		}
		if(!$status_id||$status_id=='completed'){
		$order_c = $this->Reports_Marketing_Model->get_cus_order_summary($from_date,$to_date,$route_id,$cus_id,'completed',$type_id);	
		}
     
		$pending_amount=0;
		if(isset($order_p['net_amount'])){$pending_amount=$order_p['net_amount'];}
		$completed_amount=0;
		if(isset($order_c['net_amount'])){$completed_amount=$order_c['net_amount'];}
		
		echo json_encode(array(
            'pending_total' => $pending_amount,
			'completed_total' => $completed_amount,
			'order_total' => $pending_amount+$completed_amount,
			
        ));
    }
	
	public function transactions_load()
{
	//echo 'dddd';
	$search_key=$this->input->get('search');
	$search_key_val=$search_key['value'];
	$start=$this->input->get('start');
	$length=$this->input->get('length');
	$warehouse_id=$this->input->get('warehouse_id');
	$fxd_ass_id=$this->input->get('fxd_ass_id');
	$srh_from_date=$this->input->get('srh_from_date');
	$srh_to_date=$this->input->get('srh_to_date');
	
 	$transactions_list = $this->Reports_Marketing_Model->get_transactions_list($fxd_ass_id,$warehouse_id,$srh_from_date,$srh_to_date);
	$totalData=count($transactions_list);
	$totalFiltered = $totalData; 
 
	$data=array();
	$x=0;
	foreach($transactions_list as $row){
	$x++;
	$nestedData=array();
	$nestedData[]=$x;
	$nestedData[]=$row['fxd_ass_name'].' / '.$row['etp_name'];;
	$nestedData[]='';//$row['fa_type_name'];
	$nestedData[]='';//$row['fam_name'];
	$nestedData[]=site_date_time($row['acctrnss_date']);
	$nestedData[]=$row['acctrnss_amount'];
	//$nestedData[]=$row['fxd_ass_amount'];
	$status='';
	if($row['fxd_ass_status']==1)
	{
	$status='<center><span class="label label-success">Enable</span></center>';
	}
	else if($row['fxd_ass_status']==0)
	{
	$status='<center><span class="label label-warning">Disable</span></center>';
	}
	//$nestedData[]=$status;
	$action='';
	$nestedData[]=$action;
	$data[]=$nestedData;
	}
	$json_data = array(
	"data"=>$data
	);
	//echo json_encode($json_data);	
	 $json_data = array(
			//"draw"            => intval( $requestData['draw'] ),  
			"recordsTotal"    => intval( $totalData ),  
			"recordsFiltered" => intval( $totalFiltered ),
			"data"            => $data 
			);
        echo json_encode($json_data);
}	
//----------------------------------------------------------------------
	
	 public function cus_due_report()
    {
        $data['main_menu_name']      = $this->main_menu_name;
        $data['sub_menu_name']       = 'cus_due_report';
		$data['route_list'] 		 = $this->Route_Model->get_all_routes();
        $data['cus_list'] 			 = $this->Customer_Model->get_all_customers();
		$data['type_list'] 			 = $this->In_Type_Model->get_active_in_types();		
        $this->load->view('marketing_reports/cus_due_report', $data);
    }
	 public function get_customer_due_report()
    {
        $from_date            = $this->input->get('from_date');
        $to_date			  =$this->input->get('to_date');
		$route_id			  =$this->input->get('route_id');
		$cus_id			  =$this->input->get('cus_id');
		$status_id		  =$this->input->get('status_id');
		$type_id		  =$this->input->get('type_id');
		
		$from_date=date('Y-m-d', strtotime($from_date));
		$to_date=date('Y-m-d', strtotime($to_date));	
		
        $invoice_product_list = $this->Reports_Marketing_Model->get_cus_due_list($from_date,$to_date,$route_id,$cus_id,$status_id,$type_id);
        $json_data            = array();
		
        foreach ($invoice_product_list as $row) {
            $nested_data        = array();
			
           // $sold_qty_and_value = $this->Reports_Marketing_Model->get_sold_qty_and_sub_total_by_period($from_date,$to_date,$row['product_id'],$rep_id);
			$s_paid = $this->Reports_Marketing_Model->get_all_paid_total_by_sale_id($row['sale_id']);
			$nested_data[]      = $row['sale_datetime'];
			$nested_data[]      = $row['invoice_type_name'];
            $nested_data[]      = $row['sale_reference_no']."  ".$row['card_ref_number'];
			$nested_data[]      = $row['cus_code'];
            $nested_data[]      = $row['cus_name'];
			$nested_data[]      = $row['due_date'];	
			$nested_data[]      = $row['sale_total'];
			$nested_data[]      = $s_paid;
				
			$nested_data[]      = $row['sale_total']-$s_paid;		
			
            $json_data[]        = $nested_data;
        }
        echo json_encode(array(
            'data' => $json_data
        ));
    }
	
	public function get_due_summary_report()
    {
        $from_date            = $this->input->post('from_date');
        $to_date			  =$this->input->post('to_date');
		$route_id			  =$this->input->post('route_id');
		$cus_id			  =$this->input->post('cus_id');
		$status_id		  =$this->input->post('status_id');
		$type_id		  =$this->input->post('type_id');
		
		$from_date=date('Y-m-d', strtotime($from_date));
		$to_date=date('Y-m-d', strtotime($to_date));	
		
		
		if(!$status_id||$status_id=='pending'){
		$order_p = $this->Reports_Marketing_Model->get_cus_order_summary($from_date,$to_date,$route_id,$cus_id,'pending',$type_id);	
		}
		if(!$status_id||$status_id=='completed'){
		$order_c = $this->Reports_Marketing_Model->get_cus_order_summary($from_date,$to_date,$route_id,$cus_id,'completed',$type_id);	
		}
     
		$pending_amount=0;
		if(isset($order_p['net_amount'])){$pending_amount=$order_p['net_amount'];}
		$completed_amount=0;
		if(isset($order_c['net_amount'])){$completed_amount=$order_c['net_amount'];}
		
		echo json_encode(array(
            'pending_total' => $pending_amount,
			'completed_total' => $completed_amount,
			'order_total' => $pending_amount+$completed_amount,
			
        ));
    }
    //--------------------------------------------------------------------


    public function customer_outstanding_report_print()
    {
        $data['main_menu_name']      = $this->main_menu_name;
        $data['sub_menu_name']       = 'customer_outstanding_report';
        $data_list=array();

        $route_id        = $this->input->get('route_id');
		$start=1;
		$length=1000;
		$search=$this->input->get('search');
		$totalData = $this->Reports_Marketing_Model->get_all_customers_by_route_id($route_id,"","",$search);
		$totalFiltered=$totalData;
        $customer_list = $this->Reports_Marketing_Model->get_all_customers_by_route_id($route_id,$start,$length,$search);
        $json_data          = array();
        foreach ($customer_list as $row) {
            
            $total_outstanding_amount=0;
			$customer_id=$row['cus_id'];
			
			$sale_total = $this->Reports_Marketing_Model->get_all_sale_total_by_customer_id($customer_id);
			$sale_paid = $this->Reports_Marketing_Model->get_all_paid_total_by_customer_id($customer_id);		
            $sale_list = $this->Reports_Marketing_Model->get_all_sale_list_by_customer_id($customer_id);
            $return_balance = 0;//$this->Reports_Marketing_Model->get_cheque_return_balance_by_customer_id($customer_id);    
            $return_cheque_list = $this->Reports_Marketing_Model->get_all_cheque_return_list_by_customer_id($customer_id);       
            $over_cheq_list = $this->Reports_Marketing_Model->get_uncomplte_multiple_payment($customer_id);
            $cus_payment_balance=0;
            foreach($over_cheq_list as $ovc)
            {
                $id=$ovc['smp_id'];
                $sale_paid=$this->Reports_Marketing_Model->get_total_sale_paid_by_smp_id($id);		
                $return_paid=$this->Reports_Marketing_Model->get_total_cheque_return_paid_by_smp_id($id);
                $sale_balance=$ovc['smp_amount']-$return_paid-$sale_paid;
                $cus_payment_balance+=$sale_balance;
            }
			
			$table_header='<table class="table table-bordered table-condensed table-hover table-striped dataTable" id="outstanding_table">
			<thead><th class="col-sm-1">INV No</th><th class="col-sm-1">REF.NO</th><th class="col-sm-1">Inv Date</th><th class="col-sm-1">Due Date</th><th class="col-sm-1">Sale Type</th><th class="col-sm-1">Sale Total</th><th class="col-sm-1">Sale Paid</th><th class="col-sm-2">outstanding</th></thead><tbody>';       
			$table_foorter='</tbody></table>';			
			$table_body="";
			$return_full_amount=0;
			$count=0;
			foreach($sale_list as $key){
				$converted_sale_date   = date('Y-m-d', strtotime($key['sale_datetime']));
				$s_paid = $this->Reports_Marketing_Model->get_all_paid_total_by_sale_id($key['sale_id']);
				
				$return_tot=$this->Sales_Return_Model->get_relevant_return_by_sale_id($key['sale_id']);		
		if(isset($return_tot['sl_rtn_total']))
		{
		$return_tot_amt=$return_tot['sl_rtn_total'];
		}
		else
		{
			$return_tot_amt=0;
		}		
		if(isset($return_tot['sls_rtn_total_paid']))
		{
		$return_tot_paid=$return_tot['sls_rtn_total_paid'];
		}
		else
		{
			$return_tot_paid=0;
		}			
				$sale_total_full=$key['sale_total']-$return_tot_amt;
                $s_outstanding=($key['sale_total']-$return_tot_amt)-($s_paid);
                $total_outstanding_amount+=$s_outstanding;
				$count=1;
				$table_row='<tr><td>'.$key['sale_reference_no'].'</td>'.'<td>'.$key['card_ref_number'].'</td>'.'<td>'.$converted_sale_date.'</td>'.'<td>'.$key['due_date'].'</td>'.'<td><span class="'.$key['class_name_report'].'">'.$key['invoice_type_name'].'</span></td>'.'<td>'.$sale_total_full.'</td><td>'.$s_paid.'</td><td>'.$s_outstanding.'</td></tr>';
			$table_body.=$table_row;
			$return_full_amount+=$return_tot_amt;
			}			
			$table="";
			$table=$table_header.$table_body.$table_foorter;			
			
            if($count==0){$table="";}
            
            $table_header_return='<table class="table_rtn table-bordered table-condensed table-hover table-striped dataTable" id="return_table">
			<thead><th class="col-sm-1">Cheque No</th><th class="col-sm-1">Cheque Date</th><th class="col-sm-1">Return Date</th><th class="col-sm-1">Due Date</th><th class="col-sm-1">Cheque value</th><th class="col-sm-1">Panalty</th><th class="col-sm-2">Cheque Return Balance </th></thead><tbody>';       
			$table_foorter_retun='</tbody></table>';			
			$table_body_return="";
            $return_count=0;
            $total_cheq_retun_balance=0;
			foreach($return_cheque_list as $key){
                $retun_paid_amount=$this->Reports_Marketing_Model->get_cheque_reurn_paid_amount($key['ret_pay_id']);
                $chequ_return_balance_amount=$key['total_return_amount']-$retun_paid_amount;
                $che_re_due_date=date('Y-m-d', strtotime($key['return_date']. ' + 10 day'));
                $return_count=1;
				$table_row='<tr><td>'.$key['payment_ref_no'].'</td>'.'<td>'.$key['payment_date'].'</td>'.'<td>'.$key['return_date'].'</td>'.'<td>'.$che_re_due_date.'</td>'.'<td>'.$key['smp_amount'].'</td><td>'.$key['panalty_charge'].'</td><td>'.$chequ_return_balance_amount.'</td></tr>';           
                $table_body_return.=$table_row;
                $total_cheq_retun_balance+=$chequ_return_balance_amount;
            }           
            $table_retun=$table_header_return.$table_body_return.$table_foorter_retun;            
            if($return_count==0){$table_retun="";}

            $nested_data = array();           
     		$nested_data['cus_code']  = $row['cus_code'];
            $nested_data['cus_name']  = $row['cus_name'];
            $nested_data['cus_address']  = $row['cus_address'];
            $nested_data['over_paymet']  = $cus_payment_balance;
            $nested_data['chequ_return_amount']  = $total_cheq_retun_balance;
            $nested_data['table']  = $table.$table_retun;
            $nested_data['outstanding']  = $total_outstanding_amount-$cus_payment_balance; //($sale_total-$return_full_amount)-$sale_paid+$return_balance-$cus_payment_balance;
            $data_list[]    = $nested_data;
        }
        $data['outstanding_list'] =$data_list;
        $this->load->view('marketing_reports/customer_outstanding_report_print', $data);
    }



    public function sales_rep_commition_report()
    {
        $data['main_menu_name']      = $this->main_menu_name;
        $data['sub_menu_name']       = 'sales_rep_commition_report';
        $data['route_list'] = $this->Route_Model->get_all_routes();
        $this->load->view('marketing_reports/sales_rep_commition_report', $data);
    }
	 public function get_rep_commission()
    {
	 	$route_id= $this->input->get('route_id');
		$fromdate=$this->input->get('fromdate');
        $todate=$this->input->get('todate');
        $fromdate=date('Y-m-d', strtotime($fromdate));
        $todate=date('Y-m-d', strtotime($todate. ' +1 day'));	
        
        //date('Y-m-d H:i:s', strtotime($stop_date . ' +1 day'));
        
        
		$users = $this->Reports_Marketing_Model->get_salse_rep_users();	
        $json_data          = array();
        foreach ($users as $row) {
           
           
           //$sale_total_all = $this->Reports_Marketing_Model->get_sale_total_by_sale_rep($row['user_id'],$fromdate,$todate);
           $credit_sale_total = $this->Reports_Marketing_Model->get_credit_sale_total_by_sale_rep($row['user_id'],$fromdate,$todate);              
           $sale_list = $this->Reports_Marketing_Model->get_sale_list_by_sale_rep($row['user_id'],$fromdate,$todate);
           $cash_sale_return_total = $this->Reports_Marketing_Model->get_cash_sale_return_total_by_sale_rep($row['user_id'],$fromdate,$todate);
           $credit_sale_return_total = $this->Reports_Marketing_Model->get_credit_sale_return_total_by_sale_rep($row['user_id'],$fromdate,$todate);           
           $cheq_deduction = $this->Reports_Marketing_Model->get_cheque_return_deduction_total_by_sale_rep($row['user_id'],$fromdate,$todate); 
           
            $cash_sale_total=0;
            $cash_sale_total_compeled=0;
            $credit_sale_total_compeled=0;
            $cash_sale_total_compeled_after=0;
            $credit_sale_total_compeled_after=0;
            $actual_sale=0;

            foreach($sale_list as $sl){

                if($sl['invoice_type']==1){
                    if($sl['payment_status']==0)
                    {
                        continue;
                    }
                }
                $actual_sale+=$sl['sale_total'];
                $sales_pay = $this->Reports_Marketing_Model->get_sales_last_payment($sl['sale_id']);      

                if($sl['invoice_type']==1){
                    $due_date=date('Y-m-d', strtotime($sl['sale_datetime']. ' +10 day'));
                    $payment_date=date('Y-m-d', strtotime($sales_pay)); 
                    if($due_date>=$payment_date){
                        $cash_sale_total_compeled+=$sl['sale_total'];
                    } else{
                        $cash_sale_total_compeled_after+=$sl['sale_total'];
                    }                   
                }
                if($sl['invoice_type']==2){
                    $due_date=date('Y-m-d', strtotime($sl['sale_datetime']. ' +60 day'));
                    $payment_date=date('Y-m-d', strtotime($sales_pay)); 
                    if($due_date>=$payment_date){
                        $credit_sale_total_compeled+=$sl['sale_total'];
                    }else{
                        $credit_sale_total_compeled_after+=$sl['sale_total'];                        
                    }                    
                }                
            }


            $commission_cash_sale_total_compeled=($cash_sale_total_compeled/100)*0.5;
            $commission_cash_sale_total_compeled_after=($cash_sale_total_compeled_after/100)*0.25;           
            $commission_credit_sale_total_compeled=($credit_sale_total_compeled/100)*0.2;           
            $commission_credit_sale_total_compeled_after=($credit_sale_total_compeled_after/100)*0.2;            
            $commision_for_total_credit_invoices=($credit_sale_total/100)*0.25;

            $credit_return_commission_deduct=($credit_sale_return_total/100)*0.25;
            $cash_return_commission_deduct=($credit_sale_return_total/100)*0.5;

            $total_cash_commission=$commission_cash_sale_total_compeled+$commission_cash_sale_total_compeled_after;
            $total_credit_commission=$commission_credit_sale_total_compeled;
           
            $total_commission=($total_cash_commission+$total_credit_commission+$commision_for_total_credit_invoices)-($credit_return_commission_deduct+$cash_return_commission_deduct+$cheq_deduction);


            $sale_total=$cash_sale_total_compeled+$cash_sale_total_compeled_after+$credit_sale_total;

            //echo $sale_total_all -$sale_total;
            //echo "---";
		
            $nested_data = array();           
     		$nested_data[]  = $row['user_first_name']." ".$row['user_last_name'];
            $nested_data[]  = $cash_sale_total_compeled;
            $nested_data[]  = $cash_sale_total_compeled_after;
            $nested_data[]  = $credit_sale_total;            
            $nested_data[]  = $sale_total;
            $nested_data[]  = $credit_sale_total_compeled;
            $nested_data[]  = number_format($total_cash_commission, 2, '.', ',');
            $nested_data[]  = number_format($total_credit_commission+$commision_for_total_credit_invoices, 2, '.', ',');
            $nested_data[]  = number_format($total_cash_commission+$total_credit_commission+$commision_for_total_credit_invoices, 2, '.', ',');
            $nested_data[]  = $cash_sale_return_total+$credit_sale_return_total; 
            $nested_data[]  = number_format($credit_return_commission_deduct+$cash_return_commission_deduct, 2, '.', ',');            
            $nested_data[]  = $cheq_deduction;            
            $nested_data[]  = number_format($total_commission, 2, '.', ',');
            $json_data[]    = $nested_data;
        }
        echo json_encode(array(
			"recordsTotal"    => 0,  
			"recordsFiltered" =>0,
            'data' => $json_data
        ));
    }


    public function sales_rep_commition_report_breakdown()
    {
        $data['main_menu_name']      = $this->main_menu_name;
        $data['sub_menu_name']       = 'sales_rep_commition_report_breakdown';
        //$data['route_list'] = $this->Route_Model->get_all_routes();
        $data['route_list'] = $this->User_Model->get_all_cash_collector_users();
        $this->load->view('marketing_reports/sales_rep_commition_report_breakdown', $data);
    }
	 public function get_rep_commission_breakdown()
    {
	 	$route_id= $this->input->get('route_id');
		$fromdate=$this->input->get('fromdate');
        $todate=$this->input->get('todate');
        $fromdate=date('Y-m-d', strtotime($fromdate));
        $todate=date('Y-m-d', strtotime($todate. ' +1 day'));	        
        //date('Y-m-d H:i:s', strtotime($stop_date . ' +1 day'));
        //start------------------------------------------
        $sale_list = $this->Reports_Marketing_Model->get_sale_list_by_sale_rep($route_id,$fromdate,$todate);
        
        foreach($sale_list as $sl){
            $cash_in_10_days=0;
            $cash_after_10_days=0;
            $credit_sale=0;
            $credit_in_60_days=0;
            $credit_after_60_days=0;
            if($sl['invoice_type']==1){
                if($sl['payment_status']==0)
                {
                    continue;
                }
            }
            $sales_pay = $this->Reports_Marketing_Model->get_sales_last_payment($sl['sale_id']);              
            $invoice_type="undefine";
            if($sl['invoice_type']==1){
                $invoice_type="Cash";
                $due_date=date('Y-m-d', strtotime($sl['sale_datetime']. ' +10 day'));
                $payment_date=date('Y-m-d', strtotime($sales_pay)); 
                if($due_date>=$payment_date){
                    $cash_in_10_days=$sl['sale_total'];
                } else{
                    $cash_after_10_days=$sl['sale_total'];
                }                   
            }
            if($sl['invoice_type']==2){
                $invoice_type="Credit";
                $due_date=date('Y-m-d', strtotime($sl['sale_datetime']. ' +60 day'));
                $payment_date=date('Y-m-d', strtotime($sales_pay)); 
                if($due_date>=$payment_date){
                    $credit_in_60_days=$sl['sale_total'];
                }else{
                    $credit_after_60_days=$sl['sale_total'];                        
                }                    
            }              
            $commission_cash_sale_total_compeled=($cash_in_10_days/100)*0.5;
            $commission_cash_sale_total_compeled_after=($cash_after_10_days/100)*0.25;           
            $commission_credit_sale_total_compeled=($credit_in_60_days/100)*0.2;           
            $commission_credit_sale_total_compeled_after=($credit_after_60_days/100)*0.2;            
            $commision_for_total_credit_invoices=(($credit_after_60_days+$credit_in_60_days)/100)*0.25;        

           $nested_data = array();           
           $nested_data[]  = $sl['card_ref_number']." <br> ".$sl['sale_reference_no'];
           $nested_data[]  = $invoice_type;
           $nested_data[]  = date('Y-m-d', strtotime($sl['sale_datetime']));
           $nested_data[]  = $due_date;
           $nested_data[]  = $payment_date;
           $nested_data[]  = $sl['sale_total'];
           $nested_data[]  = $cash_in_10_days;
           $nested_data[]  = $cash_after_10_days;
           $nested_data[]  = $credit_after_60_days+$credit_in_60_days;
           $nested_data[]  = $credit_in_60_days;
           $nested_data[]  = number_format($commission_cash_sale_total_compeled+$commission_cash_sale_total_compeled_after, 2, '.', '');
           $nested_data[]  = number_format($commision_for_total_credit_invoices+$commission_credit_sale_total_compeled, 2, '.', '');
           $nested_data[]  = number_format($commission_cash_sale_total_compeled+$commission_cash_sale_total_compeled_after+$commision_for_total_credit_invoices+$commission_credit_sale_total_compeled, 2, '.', '');
          
           //$nested_data[]  = "";//number_format($sl['sale_total'], 2, '.', ',');
           $json_data[]    = $nested_data;
       }
       echo json_encode(array(
           "recordsTotal"    => 0,  
           "recordsFiltered" =>0,
           'data' => $json_data
       ));

    }

    public function get_rep_commission_breakdown_return()
    {
	 	$route_id= $this->input->get('route_id');
		$fromdate=$this->input->get('fromdate');
        $todate=$this->input->get('todate');
        $fromdate=date('Y-m-d', strtotime($fromdate));
        $todate=date('Y-m-d', strtotime($todate. ' +1 day'));	        
        //date('Y-m-d H:i:s', strtotime($stop_date . ' +1 day'));
        //start------------------------------------------
        $sale_return_list = $this->Reports_Marketing_Model->get_sale_return_list_by_sale_rep($route_id,$fromdate,$todate);
        
        foreach($sale_return_list as $sl){
          
            $cash_sale_retun=0;
            $credit_sale_retun=0;      
                     
            $invoice_type="undefine";
            if($sl['invoice_type']==1){
                $invoice_type="Cash";
                $cash_sale_retun=$sl['sl_rtn_total'];
                
            }
            if($sl['invoice_type']==2){
                $invoice_type="Credit";
                $credit_sale_retun=$sl['sl_rtn_total'];
            }              
            $return_cash_commission=($cash_sale_retun/100)*0.5;
            $return_credit_commission=($credit_sale_retun/100)*0.25;                 

           $nested_data = array();           
           $nested_data[]  = $sl['sl_rtn_reference_no'];
           $nested_data[]  = $invoice_type;
           $nested_data[]  = date('Y-m-d', strtotime($sl['sl_rtn_datetime']));     
           $nested_data[]  = $sl['sl_rtn_total'];
           $nested_data[]  = $cash_sale_retun;
           $nested_data[]  = $credit_sale_retun;
           $nested_data[]  = number_format($return_cash_commission, 2, '.', '');
           $nested_data[]  = number_format($return_credit_commission, 2, '.', '');          
           $nested_data[]  = number_format($return_cash_commission+$return_credit_commission, 2, '.', '');
           
           //$nested_data[]  = "";//number_format($sl['sale_total'], 2, '.', ',');
           $json_data[]    = $nested_data;
       }
       echo json_encode(array(
           "recordsTotal"    => 0,  
           "recordsFiltered" =>0,
           'data' => $json_data
       ));
    }





















	
}