<?php

require APPPATH . '/libraries/REST_Controller.php';

use Restserver\Libraries\REST_Controller;

class Orders extends REST_Controller
{

    /**
     * Get All Data from this method.
     *
     * @return Response
     */
    public function __construct()
    {
        parent::__construct();
        $this->load->database();
        $this->load->model('counter_model');
        $this->load->model('transfer_model');
        $this->load->model('stock_counter_model');
        $this->load->model('order_model');
        ini_set('upload_max_filesize', '60M');     
        ini_set('max_execution_time', '999');
        ini_set('memory_limit', '128M');
        ini_set('post_max_size', '60M'); 
    }

    /**
     * Get All Data from this method.
     *
     * @return Response
     */
    public function index_get()
    {
        $orders = $this->order_model->get_pendding_bulk_orders();
        $response = array(
            'result' => $orders,
            'status' => 1,
        );
        $this->response($response, REST_Controller::HTTP_OK);
    }

    public function productsearch_get()
    {
        $search_key_val = $this->get('search_string');
        $this->db->select("o.*,p.product_id,p.product_name,p.product_code");
        $this->db->from('production_batch_items o');
        $this->db->join("product p", "p.product_id = o.pbi_product_id", "inner");
        $this->db->where("o.stock_clean", 0);
        $this->db->where("o.finish_status",1);
        $this->db->like('p.product_name', $search_key_val, 'after');//after
        $this->db->or_like('p.product_code', $search_key_val, 'after');
        //$this->db->or_where("o.batch_status = 1 AND  o.batch_ref_number LIKE '$search_key_val%'");
        $this->db->group_by('o.pbi_id');
        //$this->db->limit(10);
        $query = $this->db->get();
        //echo $this->db->last_query();
        $datar = $query->result_array();
        $data = array();
        foreach ($query->result_array() as $r) {
            $stock = $this->counter_model->getFinalProductStockBalance('', $r['pbi_product_id'], $r['pbi_id']);
            if($stock>0){
                $nested_data = array(
                    'id' => $r['pbi_id'],
                    'product_code' => $r['product_code'],
                    'text' => $r['product_name'].'('.$r['product_code'].')'.", BATCH  " . $r['pbi_ref_no'] . ", COST RS." . $r['pbi_unit_cost'] . ", STOCK " . $stock,
                );
                $data[] = $nested_data;
            }else{
               // $data[] = array();
            }
        }

        //return $query->result_array();

        $this->response($data, REST_Controller::HTTP_OK);
    }


    /**
     * Get All Data from this method.
     *
     * @return Response
     */
    public function index_post()
    {
        $orders_ids = $this->post('orders');
        $data = array(
            'bom_recived_status' => 1,
        );
        $this->db->where_in("bom_id", $orders_ids);
        $update_ordes = $this->db->update('bulk_order_master', $data);
            if($update_ordes){
                $response = array(
                        'status' => 1,
                        'msg' => 'Updated.',
                    );
            }else{
                 $response = array(
                        'status' => 0,
                        'msg' => 'Fail.',
                    );
            }
        
        
        $this->response($response, REST_Controller::HTTP_OK);
    }

    /**
     * Get All Data from this method.
     *
     * @return Response
     */
    public function index_put($id)
    {
        $input = $this->put();
        $this->db->update('products', $input, array('id' => $id));

        $this->response(['Product updated successfully.'], REST_Controller::HTTP_OK);
    }

    /**
     * Get All Data from this method.
     *
     * @return Response
     */
    public function index_delete($id)
    {
        
        $this->db->delete('products', array('id' => $id));
        $this->response(['Product deleted successfully.'], REST_Controller::HTTP_OK);
    }
}
