<?php
if (!defined('BASEPATH'))
    exit('No direct script access allowed');
    //header('Access-Control-Allow-Origin: *');   
class Summary extends CI_Controller
{
    var $main_menu_name = "reports";
    var $sub_menu_name = "";
    private $main_model;
   
    public function __construct()
    {
        parent::__construct();
        date_default_timezone_set("Asia/Colombo");
        $this->load->model('Common_Model');
        $this->load->model('summary_model');
        $this->load->model('warehouse_model');
    }
    
    /*View Methods*/
    public function daily_summary()
    {
        $data['main_menu_name']    = $this->main_menu_name;
        $data['sub_menu_name']     = 'rep_daily_summary';
        $data['warehouse_list']    = $this->warehouse_model->get_all_warehouse();
        $this->load->view('rep_daily_summary', $data);
    }
    /*Calculation Methods*/
    function getNextDate($inputDate) {
        // Create a DateTime object from the input date
        $currentDate = new DateTime($inputDate);

        // Add one day to the current date
        $nextDate = $currentDate->modify('+1 day');

        // Format the next date
        $formattedNextDate = $nextDate->format('Y-m-d');

        return $formattedNextDate;
    }
    function gen_summary(){
        if(!$this->session->userdata('ss_user_id')){
            echo json_encode(array(
                'status' => false,
                'msg' => 'Please login'
            ));
            return;
        }
        $date = $this->input->post('date');
        if(!$date){
            echo json_encode(array(
                'status' => false,
                'msg' => 'Date is required'
            ));
            return;
        }
        /* Loop through number of days*/
        $num_days = 1;
        for($i = 0; $i < $num_days; $i++ ){
            $ttl_value_of_return_to_suppliers = 0;
            $ttl_value_of_paybacks_from_suppliers = 0;
            
            $a = $this->summary_model->check_report_availability($date);
            if($a){
                $date = $this->getNextDate($date);
                continue;
            }
            
            $ttl_purchases_value = $this->summary_model->get_sum_of_purchases($date);
            $ttl_pymnts_for_purchases = $this->summary_model->get_sum_of_grn_payments($date);
            
            $ttl_cost_of_sales = 0;//$this->summary_model->get_sum_of_sales_cost($date);
            $ttl_sales  = 0;//$this->summary_model->get_sum_of_sales($date);
            
            /*MAP SALES TABLE*/
            $get_count = false;
            $sales_data_for_day = $this->summary_model->get_sales_data_for_summary_report($date, $this->session->userdata('ss_warehouse_id'), $get_count);
            
            // DT summary means, dine type summary
            $dt_summary = array(
                'di' => array(
                    'count' => 0,
                    'amount' => 0
                    ),
                'ta' => array(
                    'count' => 0,
                    'amount' => 0
                    ),
                'dl' => array(
                    'count' => 0,
                    'amount' => 0
                    )
            );
            // Loop through each sale record for a day and extract meaningful data
            foreach($sales_data_for_day as $row){
                // Calculating total cost of sale by collecting cost of each sale
                $ttl_cost_of_sales += $row->cost_total;
                
                // Calculating total amount of sale by collecting sale amount of each sale
                $ttl_sales += $row->sale_total;
                
                // Switching the dine type / order type and collect figures
                switch($row->dine_type){
                    case 1 : 
                        $dt_summary['di']['count'] += 1;
                        $dt_summary['di']['amount'] += $row->sale_total;
                        break;
                    case 2 : 
                        $dt_summary['ta']['count'] += 1;
                        $dt_summary['ta']['amount'] += $row->sale_total;
                        break;
                    case 3 : 
                        $dt_summary['dl']['count'] += 1;
                        $dt_summary['dl']['amount'] += $row->sale_total;
                        break;
                }
            }
            
            $ttl_payments_for_sales = $this->summary_model->get_sum_of_sale_payments($date);
            
            $ttl_value_of_customer_returns = $this->summary_model->get_sum_of_customer_returns($date);
            $ttl_value_of_pay_back_to_cus = 0;
            
            // In below array, we save extra sales figures which helps for other reports
            // You can put your own data structure below
            $extra_figures = array();
            
            // Collect Extra Sales related figures
            //  ++Payments
            $sale_cash = $this->summary_model->get_pymnt_summary($date,'sale','cash');
            $sale_credit_card = $this->summary_model->get_pymnt_summary($date,'sale','cc');
            $sale_cheque = $this->summary_model->get_pymnt_summary($date,'sale','cheque');
            
            // Map of sales data figure
            $sales_extra = array();
                // Methods of payments summary
                $mop = array(
                    "cash" => $sale_cash,
                    "cc" => $sale_credit_card,
                    "cheque" => $sale_cheque,
                );
                // Put MOP summary into the sales extra array
                $sales_extra['mop'] = $mop;
            
            // Order type summary / DT summary
                $sales_extra['dt'] = $dt_summary;
            
            /*At the end, push all the extra figures in to $extra_figures*/
            // --Loading $sales_extra into $extra_figures
            $extra_figures['sales_extra'] = $sales_extra;
            /*
                {
                    "sales" : {
                        "ot":{
                            "dine_in"   : "400",
                            "take_away" : "350",
                            "delivery"  : "600"
                        },
                        "mop":{
                            "cash"      : "400",
                            "cc"        : "350",
                            "cheque"    : "600"
                        }
                    }
                }
            */
            
            $data = array(
                'rep_for_date' => $date,
                'created_by' => $this->session->userdata('ss_user_id'),
                'ttl_purchases_value' => $ttl_purchases_value,
                'ttl_pymnts_for_purchases' => $ttl_pymnts_for_purchases,
                'ttl_value_of_return_to_suppliers' => $ttl_value_of_return_to_suppliers,
                'ttl_value_of_paybacks_from_suppliers' => $ttl_value_of_paybacks_from_suppliers,
                'ttl_cost_of_sales' => $ttl_cost_of_sales,
                'ttl_sales' => $ttl_sales,
                'ttl_payments_for_sales' => $ttl_payments_for_sales,
                'ttl_value_of_customer_returns' => $ttl_value_of_customer_returns,
                'ttl_value_of_pay_back_to_cus' => $ttl_value_of_pay_back_to_cus,
                'extra_figures' => json_encode($extra_figures)
            );
            // Call the model to save data
            $this->summary_model->saveData($data);
            
            $date = $this->getNextDate($date);
        }
        echo json_encode(array(
            'status' => true
        ));
        return;
        
    }

    /*MOP*/
    function gen_in_mop_summary(){
        if(!$this->session->userdata('ss_user_id')){
            echo json_encode(array(
                'status' => false,
                'msg' => 'Please login'
            ));
            return;
        }
        $date = $this->input->post('date');
        if(!$date){
            echo json_encode(array(
                'status' => false,
                'msg' => 'Date is required'
            ));
            return;
        }
        for($i = 0; $i < 60; $i++ ){
            $a = $this->summary_model->check_in_mop_report_availability($date);
            if($a){
                $date = $this->getNextDate($date);
                continue;
            }
            /*sale*/
            $sale_cash = $this->summary_model->get_pymnt_summary($date,'sale','cash');
            $sale_credit_card = $this->summary_model->get_pymnt_summary($date,'sale','cc');
            $sale_cheque = $this->summary_model->get_pymnt_summary($date,'sale','cheque');
            
            $data = array(
                'rep_for_date' => $date,
                'created_by' => $this->session->userdata('ss_user_id'),
                'paid_for' => 'sale',
                'cash' => $sale_cash,
                'credit_card' => $sale_credit_card,
                'cheque' => $sale_cheque
            );
            if($sale_cash || $sale_credit_card || $sale_cheque)
                $this->summary_model->saveMopSummaryData($data);
            
            $date = $this->getNextDate($date);
            
            /*Add more `paid_for` here...*/
        }
        
        echo json_encode(array(
            'status' => true
        ));
        return;
    }
    /*function get_daily_report(){
        $date = $this->input->post('date');
        if(!$date){
            echo json_encode(array(
                'status' => false,
                'msg' => 'Date is required'
            ));
            return;
        }
        $rep = $this->summary_model->get_report($date);
        header("Content-type:application/json");
        echo json_encode($rep);
    }*/
    function get_daily_report(){
        $date = $this->input->post('date');
        $date_to = $this->input->post('date_to');
        
        if(!$date){
            echo json_encode(array(
                'status' => false,
                'msg' => 'Date is required'
            ));
            return;
        }
        if(!$date_to){
            $rep = $this->summary_model->get_report($date);
            header("Content-type:application/json");
            echo json_encode($rep);
        }else{
            $data_list = $this->summary_model->get_report($date,$date_to);
            
            $sum_of_data = array(
                'rep_for_date' => $date,
                'rep_for_date_to' => $date_to,
                'created_on' => date("Y-m-d H:i A"),
                'created_by' => $this->session->userdata('ss_user_id'),
                'last_modified_on' => date("Y-m-d H:i A"),
                'ttl_purchases_value' => 0.00,
                'ttl_pymnts_for_purchases' => 0.00,
                'ttl_value_of_return_to_suppliers' => 0.00,
                'ttl_value_of_paybacks_from_suppliers' => 0.00,
                'ttl_sales' => 0.00,
                'ttl_sales_cancelled' => 0.00,
                'ttl_cost_of_sales' => 0.00,
                'ttl_payments_for_sales' => 0.00,
                'ttl_value_of_customer_returns' => 0.00,
                'ttl_value_of_pay_back_to_cus' => 0.00,
                'extra_figures' => array(
                    'sales_extra' => array(
                        'mop' => array(
                            'cash' => '0.00',
                            'cc' => '0.00',
                            'cheque' => 0
                        ),
                        'dt' => array(
                            'di' => array(
                                'count' => 0,
                                'amount' => 0
                            ),
                            'ta' => array(
                                'count' => 0,
                                'amount' => 0
                            ),
                            'dl' => array(
                                'count' => 0,
                                'amount' => 0
                            )
                        )
                    )
                )
            );
            foreach ($data_list as $row) {
                $sum_of_data['ttl_purchases_value'] += $row->ttl_purchases_value;
                $sum_of_data['ttl_pymnts_for_purchases'] += $row->ttl_pymnts_for_purchases;
                $sum_of_data['ttl_value_of_return_to_suppliers'] += $row->ttl_value_of_return_to_suppliers;
                $sum_of_data['ttl_value_of_paybacks_from_suppliers'] += $row->ttl_value_of_paybacks_from_suppliers;
                $sum_of_data['ttl_sales'] += $row->ttl_sales;
                $sum_of_data['ttl_sales_cancelled'] += $row->ttl_sales_cancelled;
                $sum_of_data['ttl_cost_of_sales'] += $row->ttl_cost_of_sales;
                $sum_of_data['ttl_payments_for_sales'] += $row->ttl_payments_for_sales;
                $sum_of_data['ttl_value_of_customer_returns'] += $row->ttl_value_of_customer_returns;
                $sum_of_data['ttl_value_of_pay_back_to_cus'] += $row->ttl_value_of_pay_back_to_cus;
            
                // Decode the JSON string and sum up the values
                $extra_figures = json_decode($row->extra_figures, true);
            
                $sum_of_data['extra_figures']['sales_extra']['mop']['cash'] += $extra_figures['sales_extra']['mop']['cash'];
                $sum_of_data['extra_figures']['sales_extra']['mop']['cc'] += $extra_figures['sales_extra']['mop']['cc'];
                $sum_of_data['extra_figures']['sales_extra']['mop']['cheque'] += $extra_figures['sales_extra']['mop']['cheque'];
                $sum_of_data['extra_figures']['sales_extra']['dt']['di']['count'] += $extra_figures['sales_extra']['dt']['di']['count'];
                $sum_of_data['extra_figures']['sales_extra']['dt']['di']['amount'] += $extra_figures['sales_extra']['dt']['di']['amount'];
                $sum_of_data['extra_figures']['sales_extra']['dt']['ta']['count'] += $extra_figures['sales_extra']['dt']['ta']['count'];
                $sum_of_data['extra_figures']['sales_extra']['dt']['ta']['amount'] += $extra_figures['sales_extra']['dt']['ta']['amount'];
                $sum_of_data['extra_figures']['sales_extra']['dt']['dl']['count'] += $extra_figures['sales_extra']['dt']['dl']['count'];
                $sum_of_data['extra_figures']['sales_extra']['dt']['dl']['amount'] += $extra_figures['sales_extra']['dt']['dl']['amount'];
            }

            // Format numbers to have 2 decimal places
            foreach ($sum_of_data as $key => $value) {
                if (is_numeric($value)) {
                    $sum_of_data[$key] = number_format($value, 2);
                }
            }

            // Encode 'extra_figures' as a JSON string
            $sum_of_data['extra_figures'] = json_encode($sum_of_data['extra_figures']);

            header("Content-type:application/json");
            echo json_encode($sum_of_data);
        }
    }
}