<?php
if (!defined('BASEPATH'))
    exit('No direct script access allowed');
header('Access-Control-Allow-Origin: *'); 
class API extends CI_Controller
{
    var $main_menu_name = "";
    var $sub_menu_name = "";
    public function __construct()
    {
        parent::__construct();
        $this->load->model('common_model');
        $this->load->model('Stock_Transfer_Model');
        /*
           header('Content-Type: application/json');
            if (!isset($_SERVER['CONTENT_TYPE'])) {
                $data = array(
                    "status" => 0,
                    "msg" => "Content Type undefined.",
                    "err_code" => "error-400-i"
                );
                echo json_encode($data);
                exit();
            }
            if ($_SERVER['CONTENT_TYPE'] !== "application/json" && $_SERVER['CONTENT_TYPE'] !== "application/json; charset=utf-8") {
                $data = array(
                    "status" => 0,
                    "msg" => "Invalid content type! JSON required. Received:" . $_SERVER['CONTENT_TYPE'],
                    "err_code" => "error-401-i"
                );
                echo json_encode($data);
                exit();
            }
            $_POST = json_decode(file_get_contents("php://input"), true);
            */
       
      
    }
    public function index()
    {
        $data = array(
            "status" => 0,
            "msg" => "Error",
            "err_code" => "error-200-a"
        );
        echo json_encode($data);
    }
    
    function transfer_grn()
    {
       if (isset($_SERVER['HTTP_ORIGIN'])) {
      // Decide if the origin in $_SERVER['HTTP_ORIGIN'] is one
      // you want to allow, and if so:
      header("Access-Control-Allow-Origin: {$_SERVER['HTTP_ORIGIN']}");
      header('Access-Control-Allow-Credentials: true');
      header('Access-Control-Max-Age: 86400');    // cache for 1 day
    }
    // Access-Control headers are received during OPTIONS requests
    if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {

      if (isset($_SERVER['HTTP_ACCESS_CONTROL_REQUEST_METHOD']))
        // may also be using PUT, PATCH, HEAD etc
        header("Access-Control-Allow-Methods: GET, POST, OPTIONS");

      if (isset($_SERVER['HTTP_ACCESS_CONTROL_REQUEST_HEADERS']))
        header("Access-Control-Allow-Headers: {$_SERVER['HTTP_ACCESS_CONTROL_REQUEST_HEADERS']}");

      exit(0);
    } 
        $id = $this->input->get('id');
        $d           = $this->Stock_Transfer_Model->get_trasfer_product_list_api($id);
   
        if (!empty($d)) {
            foreach ($d as $key => $row) {
                $d[$key]->product_id    = $d[$key]->product_id + 0;
                $d[$key]->product_retail_pirce = $d[$key]->product_retail_pirce + 0;
                $d[$key]->product_cost  = $d[$key]->product_cost + 0;
                $d[$key]->product_code  = $d[$key]->product_code;
                $d[$key]->stm_no  = $d[$key]->stm_no;
                $d[$key]->product_name  = $d[$key]->product_name;
                $d[$key]->quantity    = $d[$key]->quantity + 0;
                
            }
            echo json_encode(array(
                "status" => 1,
                "msg" => "Success",
                "products" => $d,
                'stm_no'=>$d[$key]->stm_no,
                'stm_receved_status'=>$d[$key]->stm_receved_status
            ));
            $data=array('stm_receved_status'=>"1");
            $this->Stock_Transfer_Model->update_transfer_master($id,$data);
        } else {
            $jproduct = array();
            echo json_encode(array(
                "status" => 0,
                "msg" => "Failed. (Error code: error-403-i)",
                "products" => $jproduct
            ));
        }
    }
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
   
    function get_products($category_id = "")
    {
        $category_id = $this->input->post('category_id');
        $out_cat     = '';
        $out_sub     = '';
        $d           = $this->api_model->get_product_by_cat_id($category_id);
        if (!empty($d)) {
            foreach ($d as $key => $row) {
                $d[$key]->product_thumb = asset_url() . 'uploads/thumbs/' . $d[$key]->product_thumb;
                $d[$key]->product_image = asset_url() . 'uploads/' . $d[$key]->product_image;
                $d[$key]->product_id    = $d[$key]->product_id + 0;
                $d[$key]->product_price = $d[$key]->product_price + 0;
                $d[$key]->cat_id        = $d[$key]->cat_id + 0;
                $d[$key]->cat_name        = $d[$key]->cat_name;
                $d[$key]->sub_cat_id    = $d[$key]->sub_cat_id + 0;
                $d[$key]->min_order_qty = $d[$key]->min_order_qty + 0;
            }
            echo json_encode(array(
                "status" => 1,
                "msg" => "Success",
                "products" => $d
            ));
        } else {
            $jproduct = array();
            echo json_encode(array(
                "status" => 0,
                "msg" => "Failed. (Error code: error-403-i)",
                "products" => $jproduct
            ));
        }
    }
    function get_product_info()
    {
        $product_id = $this->input->post('product_id');
        $out_cat    = '';
        $out_sub    = '';
        $d          = $this->api_model->get_product_by_product_id($product_id);
        if (!empty($d)) {
            $d['product_thumb'] = asset_url() . 'uploads/thumbs/' . $d['product_thumb'];
            $d['product_image'] = asset_url() . 'uploads/' . $d['product_image'];
            $d['product_id']    = $d['product_id'] + 0;
            $d['product_price'] = $d['product_price'] + 0;
            $d['cat_id']        = $d['cat_id'] + 0;
            $d['sub_cat_id']    = $d['sub_cat_id'] + 0;
            $d['min_order_qty'] = $d['min_order_qty'] + 0;
            $d['sizes']         = json_decode("{}");
            $sizes              = $this->api_model->get_product_sizes_by_product_id($product_id);
            if (!empty($sizes)) {
                $d['sizes'] = $sizes;
            }
            echo json_encode(array(
                "status" => 1,
                "msg" => "Success",
                "product_info" => $d
            ));
        } else {
            $jproduct = array();
            $ret      = json_encode(array(
                "status" => 0,
                "msg" => "Failed. (Error code: error-404-i)",
                "product_info" => json_decode("{}")
            ));
            echo $ret;
        }
    }
    /*add grn*/
    public function add_fg()
    {
        $this->load->library('form_validation');
        $num_products_inserted = 0;
        //print_r($_SUBMIT);
        $status = 0;
        $msg = '';
        $return_data  = '';
        
        $lastid = '';
        
        $this->form_validation->set_rules('supplier_name', 'supplier_name', 'required');
        $this->form_validation->set_rules('warehouse_id', 'Warehouse_id', 'required');
        if ($this->form_validation->run() == FALSE) {
            $msg .= "Failed. (Error code: error-406-i)".validation_errors()."\n";
        } else {
            $warehouse_id        = $this->input->post('warehouse_id');
            $warehouse_info      = $this->warehouse_model->get_warehouse_info($warehouse_id);
            if(empty($warehouse_info)){
                $msg .= "Failed. Invalid warehouse_id (Error code: error-408-i). \n";
            }else{
                $perfix_for_contract = 'GRN-EXT-' . $warehouse_info['code'] . "/";
                $reference_no        = $this->common_model->gen_ref_number('id', 'purchases', $perfix_for_contract);
                $supplier_name       = $this->input->post('supplier_name');
                $this->db->trans_start();
                $supplier_id         = $this->check_supplier($supplier_name);
                $podate              = date("Y-m-d H:i:s");
                $supp_invocie_no = $this->input->post('supp_invocie_no');
                $discount            = $this->input->post('discount');
                $order_cal_des       = $this->input->post('discount_amount');
                $total               = $this->input->post('sub_total');
                $grand_total         = $this->input->post('grand_total');
                $note                = $this->input->post('note');
                $uuid                = $this->input->post('uuid');
                $products            = $this->input->post('products');
                
                $header_data = array(
                    'uuid' => $uuid,
                    'reference_no' => $reference_no,
                    'warehouse_id' => $warehouse_id,
                    'supplier_id' => $supplier_id,
                    'date' => $podate,
                    'note' => $note,
                    'total' => $total,
                    'grand_total' => $grand_total,
                    'discount' => $discount,
                    'discount_cal' => $order_cal_des,
                    'supp_invocie_no' => $supp_invocie_no
                );
                $grn_header_id       = $this->purchases_model->add_grn_header_api($header_data);
//                $lastid              = $this->db->insert_id();
                if ($grn_header_id) {
                    //insert sale item data
                    $data_item = array();
                    for ($i = 0; $i < count($products); $i++) {
                        if (!isset($products[$i]['product_code']) || !isset($products[$i]['product_name']) || !isset($products[$i]['qty']) || !isset($products[$i]['unit_price']) || !isset($products[$i]['selling_price'])){
                            $msg .= "Error! undefined fields in products!\n";
                            break;
                        }
                        if (!($products[$i]['product_code']) || !($products[$i]['product_name']) || !($products[$i]['qty']) || !($products[$i]['unit_price']) || !($products[$i]['selling_price'])){
                            $msg .= "Error! empty fields in products!\n";
                            break;
                        }
                        $product_id = 0;
                        $product_info = $this->product_models->get_product_by_code($products[$i]['product_code']);
                        if(empty($product_info)){
                            $new_product_data = array(
                                'cat_id' => 1,
                                'sub_cat_id' => 1,
                                'product_name' => $products[$i]['product_name'],
                                'product_code' => $products[$i]['product_code'],
                                'product_cost' => $products[$i]['unit_price'],
                                'product_price' => $products[$i]['selling_price'],
                                /*'wholesale_price' => $wholesale_price,
                                'credit_salling_price' => $credit_salling_price,
                                'tax' => $tax,
                                'product_details' => $product_details,*/
                            );
                            $product_id = $this->product_models->save_product_api($new_product_data);
                        }else
                        $product_id = $product_info->product_id;
                        
                        $data_item = array(
                            'purchase_id' => $grn_header_id,
                            'product_id' => $product_id,
                            'product_code' => $products[$i]['product_code'],
                            'product_name' => $products[$i]['product_name'],
                            'quantity' => $products[$i]['qty'],
                            'unit_price' => $products[$i]['unit_price'],
                            'product_price' => $products[$i]['selling_price'],
                            'sub_total' => floatval($products[$i]['qty'])* floatval($products[$i]['unit_price']),
                            /*'discount' => $products[$i]['discount'],
                            'discount_cal' => $row[$i]['discount_val']*/
                        );
                        if(!$this->purchases_model->add_grn_list_item($data_item)){
                            $this->db->trans_rollback();
                            break;
                        }
                        if($product_id)
                            $num_products_inserted++;
                    }
                    /*
                    for ($i = 0; $i < count($products); $i++) {
                    if (!isset($products[$i]['product_id']))
                        continue;
                    */
                    if($num_products_inserted != count($products)){
                        $this->db->trans_rollback();
                        $msg .= "Failed. Product list error (Error code: error-409-i)\n";   
                    }else{
                        $this->db->trans_complete();
                        $status = 1;
                        $msg .= "successfully added.";   
                    }
                }else{
                    $msg .= "Failed. (Error code: error-407-i). \n";
                }
            }
        }
        echo json_encode(array(
                    "status" => $status,
                    "msg" => $msg,
                    'data' => array()
        ));
    }
    function check_supplier($supplier_name){
        $supp_id = 0;
        $supplier_data       = $this->supplier_model->get_supplier_info_by_name($supplier_name);
        if(!empty($supplier_data)){
            $supp_id = $supplier_data->supp_id;
        }else{
            $data    = array(
                'supp_company_name' => $supplier_name,
                'supp_code' => $this->common_model->gen_ref_number('supp_id', 'supplier', 'SUPP-EXT-')
            );
            $this->supplier_model->save_supplier($data, $supp_id);
            $supp_id  = $this->db->insert_id();
        }
        return $supp_id;
    }
}