<!DOCTYPE html>
<!--[if IE 7]><html class="ie ie7"><![endif]-->
<!--[if IE 8]><html class="ie ie8"><![endif]-->
<!--[if IE 9]><html class="ie ie9"><![endif]-->
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <meta name="format-detection" content="telephone=no">
  <meta name="apple-mobile-web-app-capable" content="yes">
  <link href="apple-touch-icon.png" rel="apple-touch-icon">
  <link href="favicon.png" rel="icon">
  <meta name="author" content="#{author}">
  <meta name="keywords" content="#{keyword}">
  <meta name="description" content="#{description}">
  <title>Bakery | Product Grid</title>
  <!-- Fonts-->
  <link href="https://fonts.googleapis.com/css?family=Libre+Baskerville:400,400i,700%7CPacifico%7CVarela+Round%7CPoppins" rel="stylesheet">
  <link rel="stylesheet" href="<?php echo base_url() ?>assets/plugins/font-awesome/css/font-awesome.min.css">
  <link rel="stylesheet" href="<?php echo base_url() ?>assets/plugins/jquery-bar-rating/dist/themes/fontawesome-stars.css">
  <link rel="stylesheet" href="<?php echo base_url() ?>assets/plugins/ps-icon/ps-icon.css">
  <!-- CSS Library-->
  <link rel="stylesheet" href="<?php echo base_url() ?>assets/plugins/bootstrap/dist/css/bootstrap.min.css">
  <link rel="stylesheet" href="<?php echo base_url() ?>assets/plugins/owl-carousel/assets/owl.carousel.css">
  <link rel="stylesheet" href="<?php echo base_url() ?>assets/plugins/jquery-bar-rating/dist/themes/fontawesome-stars.css">
  <link rel="stylesheet" href="<?php echo base_url() ?>assets/plugins/Magnific-Popup/dist/magnific-popup.css">
  <link rel="stylesheet" href="<?php echo base_url() ?>assets/plugins/jquery-ui/jquery-ui.min.css">
  <link rel="stylesheet" href="<?php echo base_url() ?>assets/plugins/bootstrap-datetimepicker/build/css/bootstrap-datetimepicker.min.css">
  <link rel="stylesheet" href="<?php echo base_url() ?>assets/plugins/slick/slick/slick.css">
  <link rel="stylesheet" href="<?php echo base_url() ?>assets/plugins/lightGallery-master/dist/css/lightgallery.min.css">
  <link rel="stylesheet" href="<?php echo base_url() ?>assets/plugins/revolution/css/settings.css">
  <link rel="stylesheet" href="<?php echo base_url() ?>assets/plugins/revolution/css/layers.css">
  <link rel="stylesheet" href="<?php echo base_url() ?>assets/plugins/revolution/css/navigation.css">
  <!-- Custom-->
  <link rel="stylesheet" href="<?php echo base_url() ?>assets/css/style.css">
  <!--HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries-->
  <!--WARNING: Respond.js doesn't work if you view the page via file://-->
  <!--[if lt IE 9]><script src="https://oss.maxcdn.com/libs/html5shiv/3.7.0/html5shiv.js"></script><script src="https://oss.maxcdn.com/libs/respond.js/1.4.2/respond.min.js"></script><![endif]-->
</head>
<!--[if IE 7]><body class="ie7 lt-ie8 lt-ie9 lt-ie10"><![endif]-->
<!--[if IE 8]><body class="ie8 lt-ie9 lt-ie10"><![endif]-->
<!--[if IE 9]><body class="ie9 lt-ie10"><![endif]-->
<body class="page-init">
  <div class="ps-searchbox">
    <div class="ps-searchbox__remove"><i class="fa fa-remove"></i></div>
    <div class="container">
      <header>
        <p>Enter your keywords:</p>
        <form method="post" action="/product-grid.html">
          <input class="form-control" type="text" placeholder="">
          <button><i class="ps-icon--search"></i></button>
        </form>
      </header>
      <div class="ps-searchbox__result">
        <div class="row">
          <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12 ">
            <div class="ps-product--list ps-product--list-light mt-60">
              <div class="ps-product__thumbnail"><a class="ps-product__overlay" href="product-detail.html"></a><img src="<?php echo base_url() ?>assets/images/cake/img-cr-1.jpg" alt=""></div>
              <div class="ps-product__content">
                <h4 class="ps-product__title"><a href="product-detail.html">Amazin’ Glazin’</a></h4>
                <p>Lollipop dessert donut marzipan cookie bonbon sesame snaps chocolate.</p>
                <p class="ps-product__price">
                  <del>£25.00</del>£15.00
                </p><a class="ps-btn ps-btn--xs" href="cart.html">Order now<i class="fa fa-angle-right"></i></a>
              </div>
            </div>
            <div class="ps-product--list ps-product--list-light mt-60">
              <div class="ps-product__thumbnail"><a class="ps-product__overlay" href="product-detail.html"></a><img src="<?php echo base_url() ?>assets/images/cake/img-cr-2.jpg" alt=""></div>
              <div class="ps-product__content">
                <h4 class="ps-product__title"><a href="product-detail.html">The Crusty Croissant</a></h4>
                <p>Lollipop dessert donut marzipan cookie bonbon sesame snaps chocolate.</p>
                <p class="ps-product__price">
                  <del>£25.00</del>£15.00
                </p><a class="ps-btn ps-btn--xs" href="cart.html">Order now<i class="fa fa-angle-right"></i></a>
              </div>
            </div>
          </div>
          <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12 ">
            <div class="ps-product--list ps-product--list-light mt-60">
              <div class="ps-product__thumbnail"><a class="ps-product__overlay" href="product-detail.html"></a><img src="<?php echo base_url() ?>assets/images/cake/img-cr-3.jpg" alt=""></div>
              <div class="ps-product__content">
                <h4 class="ps-product__title"><a href="product-detail.html">Amazin’ Glazin’</a></h4>
                <p>Lollipop dessert donut marzipan cookie bonbon sesame snaps chocolate.</p>
                <p class="ps-product__price">
                  <del>£25.00</del>£15.00
                </p><a class="ps-btn ps-btn--xs" href="cart.html">Order now<i class="fa fa-angle-right"></i></a>
              </div>
            </div>
            <div class="ps-product--list ps-product--list-light mt-60">
              <div class="ps-product__thumbnail"><a class="ps-product__overlay" href="product-detail.html"></a><img src="<?php echo base_url() ?>assets/images/cake/img-cr-4.jpg" alt=""></div>
              <div class="ps-product__content">
                <h4 class="ps-product__title"><a href="product-detail.html">The Crusty Croissant</a></h4>
                <p>Lollipop dessert donut marzipan cookie bonbon sesame snaps chocolate.</p>
                <p class="ps-product__price">
                  <del>£25.00</del>£15.00
                </p><a class="ps-btn ps-btn--xs" href="cart.html">Order now<i class="fa fa-angle-right"></i></a>
              </div>
            </div>
          </div>
        </div>
      </div>
      <footer class="text-center"><a class="ps-searchbox__morelink" href="product-grid.html">VIEW ALL RESULT</a></footer>
    </div>
  </div>
  <div class="header--sidebar"></div>
  <header class="header header--2" data-responsive="1199">
    <div class="header__top">
      <div class="container">
        <div class="row">
          <div class="col-lg-8 col-md-7 col-sm-12 col-xs-12 ">
            <p>No 117, Attanagalla Road, Veyangoda - Hotline: 033 22 92090</p>
          </div>
          <div class="col-lg-4 col-md-5 col-sm-12 col-xs-12 "><a class="ps-search-btn" href="#"><i class="ps-icon--search"></i></a>
            <div class="btn-group ps-dropdown"><a class="dropdown-toggle" href="#" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">USD<i class="fa fa-angle-down"></i></a>
              <ul class="dropdown-menu">
                <li><a href="#">USD</a></li>
                <li><a href="#">SGD</a></li>
                <li><a href="#">ERO</a></li>
                <li><a href="#">JPN</a></li>
              </ul>
            </div>
            <div class="btn-group ps-dropdown"><a class="dropdown-toggle" href="#" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">Language<i class="fa fa-angle-down"></i></a>
              <ul class="dropdown-menu">
                <li><a href="#">English</a></li>
                <li><a href="#">Japanese</a></li>
                <li><a href="#">Chinese</a></li>
              </ul>
            </div>
          </div>
        </div>
      </div>
    </div>

    <!-- navigation start -->
    <?php $this->load->view("common/navigation"); ?>
    <!--navigation end -->

  </header>
  <div id="back2top"><i class="fa fa-angle-up"></i></div>
  <div class="loader"></div>
  <div class="page-wrap">
    <!-- Heros-->
    <div class="ps-section--hero"><img src="<?php echo base_url() ?>assets/images/hero/01.jpg" alt="">
      <div class="ps-section__content text-center">
        <h3 class="ps-section__title">OUR BAKERY</h3>
        <div class="ps-breadcrumb">
          <ol class="breadcrumb">
          <li><a href="<?php echo base_url('home'); ?>">Home</a></li>
            <li class="active">Shop</li>
          </ol>
        </div>
      </div>
    </div>
    <div class="ps-section--page">
      <div class="container">
        <div class="row">
          <div class="col-lg-9 col-md-9 col-sm-12 col-xs-12 col-lg-push-3 col-md-push-3">
            <div class="ps-shop-grid pt-80">
              <div class="ps-shop-features">
                <div class="row">
                  <div class="col-lg-4 col-md-4 col-sm-6 col-xs-12 "><img class="mb-30" src="<?php echo base_url() ?>assets/images/product-banner/012x.jpg" alt="">
                  </div>
                  <div class="col-lg-8 col-md-8 col-sm-6 col-xs-12 "><img class="mb-30" src="<?php echo base_url() ?>assets/images/product-banner/022x.jpg" alt="">
                  </div>
                </div>
              </div>
              <div class="ps-shop-filter">
                <div class="row">
                  <div class="col-lg-5 col-md-4 col-sm-4 col-xs-12 ">
                    <div class="form-group">
                      <label>Short by:</label>
                      <select class="ps-select" data-placeholder="Popupar product">
                        <option value="01">Popular products</option>
                        <option value="01">Item 01</option>
                        <option value="02">Item 02</option>
                        <option value="03">Item 03</option>
                      </select>
                    </div>
                  </div>
                  <div class="col-lg-5 col-md-4 col-sm-4 col-xs-12 ">
                    <div class="form-group">
                      <label>Show:</label>
                      <select class="ps-select" data-placeholder="Show:">
                        <option value="01">SHOW</option>
                        <option value="02">Item 02</option>
                        <option value="03">Item 03</option>
                      </select>
                    </div>
                  </div>
                  <div class="col-lg-2 col-md-4 col-sm-4 col-xs-12 ">
                    <ul class="ps-shop-switch">
                      <li class="active"><a href="product-listing.html"><i class="fa fa-th"></i></a></li>
                      <li><a href="product-grid.html"><i class="fa fa-list"></i></a></li>
                    </ul>
                  </div>
                </div>
              </div>
              <div class="ps-shop ps-col-tiny">

                <div class="row">

                  <?php
                  foreach ($product_list as $value) { ?>

                    <div class="col-lg-4 col-md-4 col-sm-6 col-xs-12 ">
                      <div class="ps-product">
                        <div class="ps-product__thumbnail">
                          <div class="ps-badge ps-badge--new"><span>New</span></div><a class="ps-product__overlay" href="<?php echo base_url() ?>shop/product_details_view?pid=<?php echo $value['product_id']; ?>"></a><img src="<?php echo base_url() ?>admin/uploads/product/original/<?php echo $value['product_image'] ; ?>" alt="">
                          <ul class="ps-product__action">
                            <li><a class="popup-modal" href="#quickview-modal" data-effect="mfp-zoom-out" data-tooltip="View"><i class="ps-icon--search"></i></a></li>
                            <li><a href="#" data-tooltip="Add to wishlist"><i class="ps-icon--heart"></i></a></li>
                            <li><a href="#" data-tooltip="Compare"><i class="ps-icon--reload"></i></a></li>
                            <li><a href="#" data-tooltip="Add to cart"><i class="ps-icon--shopping-cart"></i></a></li>
                          </ul>
                        </div>
                        <div class="ps-product__content"><a class="ps-product__title" href="product-detail.html"><?php echo $value['product_name']; ?></a>
                          <div class="ps-product__category"><a class="ps-product__category" href="product-listing.html">cupcake</a><a class="ps-product__category" href="product-listing.html">sweet</a><a class="ps-product__category" href="product-listing.html">bio</a>
                          </div>
                          <select class="ps-rating">
                            <option value="1">1</option>
                            <option value="1">2</option>
                            <option value="1">3</option>
                            <option value="1">4</option>
                            <option value="5">5</option>
                          </select>
                          <p class="ps-product__price"><?php echo $value['product_price']." RS"; ?></p>
                        </div>
                      </div>
                    </div>

                      <?php } ?>










                  </div>


                  <div class="ps-pagination">
                    <ul class="pagination">

                      <li><a href="#"><i class="fa fa-arrow-left"></i></a></li>

                      <?php for($i=1;$i<=$no_of_pages;$i++){ ?>
                        <!--<li class="active"><a href="#">1</a></li>-->
                        <li><a href="#"><?php echo  ($i); ?></a></li>
                      <?php } ?>

                      <li><a href="#"><i class="fa fa-arrow-right"></i></a></li>
                    </ul>
                  </div>
                </div>
              </div>
            </div>
            <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12 col-lg-pull-9 col-md-pull-9">
              <div class="ps-sidebar">
                <aside class="ps-widget ps-widget--sidebar ps-widget--search">
                  <form method="post" action="search-result.html">
                    <input class="form-control" type="text" placeholder="Type here bakery name...">
                    <button type="submit"><i class="ps-icon--search"></i></button>
                  </form>
                </aside>
                <aside class="ps-widget ps-widget--sidebar ps-widget--category">
                  <div class="ps-widget__header">
                    <h3 class="ps-widget__title">CATEGORY</h3>
                  </div>
                  <div class="ps-widget__content">
                    <ul class="ps-list--circle">
                      <li class="current"><a href="product-listing.html"><span class="circle"></span>All bakery (321)</a></li>
                      <li><a href="product-listing.html"><span class="circle"></span>Amazin’ Glazin’</a></li>
                      <li><a href="product-listing.html"><span class="circle"></span>The Crusty Croissant</a></li>
                      <li><a href="product-listing.html"><span class="circle"></span>The Rolling Pin</a></li>
                      <li><a href="product-listing.html"><span class="circle"></span>Skippity Scones</a></li>
                      <li><a href="product-listing.html"><span class="circle"></span>Mad Batter</a></li>
                      <li><a href="product-listing.html"><span class="circle"></span>Confection Connection</a></li>
                    </ul>
                  </div>
                </aside>
                <aside class="ps-widget ps-widget--sidebar ps-widget--filter">
                  <div class="ps-widget__header">
                    <h3 class="ps-widget__title">Fillter Prices</h3>
                  </div>
                  <div class="ps-widget__content">
                    <div class="ac-slider" data-default-min="300" data-default-max="2000" data-max="3450" data-step="50" data-unit="$"></div>
                    <p class="ac-slider__meta">Price:<span class="ac-slider__value ac-slider__min"></span>-<span class="ac-slider__value ac-slider__max"></span></p><a class="ac-slider__filter ps-btn ps-btn--xs" href="#">Filter</a>
                  </div>
                </aside>
                <aside class="ps-widget ps-widget--sidebar ps-widget--ads">
                  <div class="ps-widget__header">
                    <h3 class="ps-widget__title">Ads Banner</h3>
                  </div>
                  <div class="ps-widget__content"><img src="<?php echo base_url() ?>assets/images/widget/banner2x.png" alt=""></div>
                </aside>
                <aside class="ps-widget ps-widget--sidebar ps-widget--best-seller">
                  <div class="ps-widget__header">
                    <h3 class="ps-widget__title">Best seller</h3>
                  </div>
                  <div class="ps-widget__content">
                    <div class="ps-product--sidebar">
                      <div class="ps-product__thumbnail"><a class="ps-product__overlay" href="product-detail.html"></a><img src="<?php echo base_url() ?>assets/images/cake/img-cake-12.jpg" alt=""></div>
                      <div class="ps-product__content">
                        <h4 class="ps-product__title"><a href="product-detail.html">Amazin’ Glazin’</a></h4>
                        <p class="ps-product__price">
                          <del>£25.00</del>£15.00
                        </p><a class="ps-btn ps-btn--xs" href="product-detail.html">Purchase</a>
                      </div>
                    </div>
                    <div class="ps-product--sidebar">
                      <div class="ps-product__thumbnail"><a class="ps-product__overlay" href="product-detail.html"></a><img src="<?php echo base_url() ?>assets/images/cake/img-cake-3.jpg" alt=""></div>
                      <div class="ps-product__content">
                        <h4 class="ps-product__title"><a href="product-detail.html">The Crusty Croissant</a></h4>
                        <p class="ps-product__price">
                          <del>£25.00</del>£15.00
                        </p><a class="ps-btn ps-btn--xs" href="product-detail.html">Purchase</a>
                      </div>
                    </div>
                    <div class="ps-product--sidebar">
                      <div class="ps-product__thumbnail"><a class="ps-product__overlay" href="product-detail.html"></a><img src="<?php echo base_url() ?>assets/images/cake/img-cake-7.jpg" alt=""></div>
                      <div class="ps-product__content">
                        <h4 class="ps-product__title"><a href="product-detail.html">The Rolling Pin</a></h4>
                        <p class="ps-product__price">
                          <del>£25.00</del>£15.00
                        </p><a class="ps-btn ps-btn--xs" href="product-detail.html">Purchase</a>
                      </div>
                    </div>
                  </div>
                </aside>
                <aside class="ps-widget ps-widget--sidebar ps-widget--tags">
                  <div class="ps-widget__header">
                    <h3 class="ps-widget__title">TAGS</h3>
                  </div>
                  <div class="ps-widget__content">
                    <ul class="ps-tags">
                      <li><a href="#">Cupcake</a></li>
                      <li><a href="#">vanila</a></li>
                      <li><a href="#">sugar flower</a></li>
                      <li><a href="#">vanila</a></li>
                      <li><a href="#">coconut</a></li>
                      <li><a href="#">vanila</a></li>
                    </ul>
                  </div>
                </aside>
              </div>
            </div>
          </div>
        </div>
      </div>

      <!-- about us start -->

      <?php $this->load->view("common/about_us"); ?>

      <!-- about us end -->

      <!--footer-->

      <!-- footer start -->

      <?php $this->load->view("common/footer"); ?>

      <!-- footer end -->
      <div class="modal-popup mfp-with-anim mfp-hide" id="quickview-modal" tabindex="-1">
        <button class="modal-close"><i class="fa fa-remove"></i></button>
        <div class="ps-product-modal ps-product--detail clearfix">
          <div class="col-lg-5 col-md-5 col-sm-12 col-xs-12 ">
            <div class="ps-product__thumbnail">
              <div class="quickview--main" data-owl-auto="true" data-owl-loop="false" data-owl-speed="10000" data-owl-gap="0" data-owl-nav="false" data-owl-dots="false" data-owl-animate-in="" data-owl-animate-out="" data-owl-item="1" data-owl-item-xs="1" data-owl-item-sm="1" data-owl-item-md="1" data-owl-item-lg="1" data-owl-nav-left="&lt;i class=&quot;fa fa-angle-left&quot;&gt;&lt;/i&gt;" data-owl-nav-right="&lt;i class=&quot;fa fa-angle-right&quot;&gt;&lt;/i&gt;">
                <div class="ps-product__image"><img src="<?php echo base_url() ?>assets/images/cake/img-cake-12.jpg" alt=""></div>
                <div class="ps-product__image"><img src="<?php echo base_url() ?>assets/images/cake/img-cake-11.jpg" alt=""></div>
                <div class="ps-product__image"><img src="<?php echo base_url() ?>assets/images/cake/img-cake-10.jpg" alt=""></div>
                <div class="ps-product__image"><img src="<?php echo base_url() ?>assets/images/cake/img-cake-6.jpg" alt=""></div>
                <div class="ps-product__image"><img src="<?php echo base_url() ?>assets/images/cake/img-cake-5.jpg" alt=""></div>
              </div>
              <div class="quickview--thumbnail" data-owl-auto="true" data-owl-loop="false" data-owl-speed="10000" data-owl-gap="20" data-owl-nav="false" data-owl-dots="false" data-owl-animate-in="" data-owl-animate-out="" data-owl-item="4" data-owl-item-xs="2" data-owl-item-sm="3" data-owl-item-md="4" data-owl-item-lg="4" data-owl-nav-left="&lt;i class=&quot;fa fa-angle-left&quot;&gt;&lt;/i&gt;" data-owl-nav-right="&lt;i class=&quot;fa fa-angle-right&quot;&gt;&lt;/i&gt;"><img src="<?php echo base_url() ?>assets/images/cake/img-cake-12.jpg" alt=""><img src="<?php echo base_url() ?>assets/images/cake/img-cake-11.jpg" alt=""><img src="<?php echo base_url() ?>assets/images/cake/img-cake-10.jpg" alt=""><img src="<?php echo base_url() ?>assets/images/cake/img-cake-6.jpg" alt=""><img src="<?php echo base_url() ?>assets/images/cake/img-cake-5.jpg" alt=""></div>
            </div>
          </div>
          <div class="col-lg-7 col-md-7 col-sm-12 col-xs-12 ">
            <header>
              <h3 class="ps-product__name">Anytime Cakes</h3>
              <select class="ps-rating">
                <option value="1">1</option>
                <option value="1">2</option>
                <option value="1">3</option>
                <option value="1">4</option>
                <option value="5">5</option>
              </select>
              <p class="ps-product__price">£15.00 <del>£25.00</del></p>
              <div class="ps-product__meta">
                <p><span> Availability: </span> In stock</p>
                <p class="category"><span>CATEGORIES: </span><a href="product-grid.html">Cupcake</a>,<a href="product-grid.html">organic</a>,<a href="product-grid.html"> sugar</a>,<a href="product-grid.html"> sweet</a>,<a href="product-grid.html"> bio</a></p>
              </div>
              <div class="form-group ps-product__size">
                <label>Size:</label>
                <select class="ps-select" data-placeholder="Popupar product">
                  <option value="01">Choose a option</option>
                  <option value="01">Item 01</option>
                  <option value="02">Item 02</option>
                  <option value="03">Item 03</option>
                </select>
              </div>
              <div class="ps-product__shop">
                <div class="form-group--number">
                  <button class="minus"><span>-</span></button>
                  <input class="form-control" type="text" value="1">
                  <button class="plus"><span>+</span></button>
                </div>
                <ul class="ps-product__action">
                  <li><a href="#" data-tooltip="Add to wishlist"><i class="ps-icon--heart"></i></a></li>
                  <li><a href="#" data-tooltip="Compare"><i class="ps-icon--reload"></i></a></li>
                </ul>
              </div>
            </header>
            <footer><a class="ps-btn--fullwidth ps-btn ps-btn--sm" href="#">Purchase<i class="fa fa-angle-right"></i></a>
              <p class="ps-product__sharing">Share with:<a href="#"><i class="fa fa-facebook"></i></a><a href="#"><i class="fa fa-google-plus"></i></a><a href="#"><i class="fa fa-twitter"></i></a></p>
            </footer>
          </div>
        </div>
      </div>
    </div>
    <!-- JS Library-->
    <script type="text/javascript" src="<?php echo base_url() ?>assets/plugins/jquery/dist/jquery.min.js"></script>
    <script type="text/javascript" src="<?php echo base_url() ?>assets/plugins/bootstrap/dist/js/bootstrap.min.js"></script>
    <script type="text/javascript" src="<?php echo base_url() ?>assets/plugins/owl-carousel/owl.carousel.min.js"></script>
    <script type="text/javascript" src="<?php echo base_url() ?>assets/plugins/overflow-text.js"></script>
    <script type="text/javascript" src="<?php echo base_url() ?>assets/plugins/masonry.pkgd.min.js"></script>
    <script type="text/javascript" src="<?php echo base_url() ?>assets/plugins/imagesloaded.pkgd.js"></script>
    <script type="text/javascript" src="<?php echo base_url() ?>assets/plugins/jquery-bar-rating/dist/jquery.barrating.min.js"></script>
    <script type="text/javascript" src="<?php echo base_url() ?>assets/plugins/jquery-nice-select/js/jquery.nice-select.min.js"></script>
    <script type="text/javascript" src="<?php echo base_url() ?>assets/plugins/Magnific-Popup/dist/jquery.magnific-popup.min.js"></script>
    <script type="text/javascript" src="<?php echo base_url() ?>assets/plugins/jquery-ui/jquery-ui.min.js"></script>
    <script type="text/javascript" src="<?php echo base_url() ?>assets/plugins/moment.js"></script>
    <script type="text/javascript" src="<?php echo base_url() ?>assets/plugins/bootstrap-datetimepicker/build/js/bootstrap-datetimepicker.min.js"></script>
    <script type="text/javascript" src="<?php echo base_url() ?>assets/plugins/slick/slick/slick.min.js"></script>
    <script type="text/javascript" src="<?php echo base_url() ?>assets/plugins/gmap3.min.js"></script>
    <script type="text/javascript" src="<?php echo base_url() ?>assets/plugins/lightGallery-master/dist/js/lightgallery-all.min.js"></script>
    <script type="text/javascript" src="https://maps.googleapis.com/maps/api/js?key=AIzaSyAx39JFH5nhxze1ZydH-Kl8xXM3OK4fvcg&amp;region=GB"></script>
    <!-- Revolution - slider--><script type="text/javascript" src="<?php echo base_url() ?>assets/plugins/revolution/js/jquery.themepunch.tools.min.js"></script>
    <script type="text/javascript" src="<?php echo base_url() ?>assets/plugins/revolution/js/jquery.themepunch.revolution.min.js"></script>
    <script type="text/javascript" src="<?php echo base_url() ?>assets/plugins/revolution/js/extensions/revolution.extension.video.min.js"></script>
    <script type="text/javascript" src="<?php echo base_url() ?>assets/plugins/revolution/js/extensions/revolution.extension.slideanims.min.js"></script>
    <script type="text/javascript" src="<?php echo base_url() ?>assets/plugins/revolution/js/extensions/revolution.extension.layeranimation.min.js"></script>
    <script type="text/javascript" src="<?php echo base_url() ?>assets/plugins/revolution/js/extensions/revolution.extension.navigation.min.js"></script>
    <script type="text/javascript" src="<?php echo base_url() ?>assets/plugins/revolution/js/extensions/revolution.extension.parallax.min.js"></script>
    <script type="text/javascript" src="<?php echo base_url() ?>assets/plugins/revolution/js/extensions/revolution.extension.actions.min.js"></script>
    <!-- Custom scripts-->
    <script type="text/javascript" src="<?php echo base_url() ?>assets/js/main.js"></script>
  </body>
  </html>
