<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Shipping_Category extends CI_Controller {

    var $main_menu_name = "settings";
	var $sub_menu_name = "shipping_category";

    public function __construct()
     {
            parent::__construct();
            $this->load->model('Shipping_Category_Models');
			$this->load->model('Common_Model');
			$this->load->model('Sequerty_Model');
     }

	public function index()
	{
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = $this->sub_menu_name;
        $this->load->view('product_category/product_shipping_category',$data);
	}

    public function add_category()
    {
        $data['id'] = 1;
        $this->load->view('product_category/create_shipping_category',$data);
    }
    public function edit_category($category_id)
    {
        $data['category_details'] = $this->Shipping_Category_Models->getCategory_by_id($category_id);
        $this->load->view('product_category/create_shipping_category',$data);
    }

    public function update_category()
    {     
        
       $category_tbl_id =$this->input->post('category_tbl_id');
       //$cat_id =$this->input->post('cat_id');
       $cat_name =$this->input->post('cat_name');
       $cat_value =$this->input->post('cat_value');

       $data=array(
        'shc_cat_name'=>$cat_name,
        'sh_cat_value'=>$cat_value,
       );
        if ($this->Shipping_Category_Models->category_update($category_tbl_id,$data)) {
            $st = array('status' =>1,'validation' =>'Done!');
            echo json_encode($st);
            } else {
                $st = array('status' =>0,'validation' =>'error occurred please contact your system administrator');
                echo json_encode($st);
            }        
    }

  

   
    public function category_save()
    {
        $this->load->library('form_validation'); //form validation lib
        //$this->form_validation->set_rules('cat_id', 'Category Code', 'required');
        $this->form_validation->set_rules('cat_name', 'Category Name', 'required');
        $this->form_validation->set_rules('cat_value', 'Category Value', 'required');
        if ($this->form_validation->run() == FALSE)
        {
           $st = array('status' =>0,'validation' => validation_errors());
           echo json_encode($st);
        }
        else
        {
            $cat_name =$this->input->post('cat_name');
            $cat_value =$this->input->post('cat_value');
            $data=array(
                'shc_cat_name'=>$cat_name,
                'sh_cat_value'=>$cat_value,
               );
                           if ($this->Shipping_Category_Models->category_save($data)) {

                       $st = array('status' =>1,'validation' =>'Done!');
                       echo json_encode($st);

               } else {
                       $st = array('status' =>0,'validation' =>'error occurred please contact your system administrator');
                       echo json_encode($st);
               }
          }
          

       

    }

    public function getCategory()
    {       
        $values = $this->Shipping_Category_Models->getCategory();
        $data = array();
        if (!empty($values)) {
            foreach ($values as $categoriy) {

            if ($categoriy->sh_cat_status == 0) {$k = "btn-warning";$m = "fa-minus-circle";} else {$k = "btn-green";$m = "fa-check";}
            
            $row = array();
               
                $row[] = strtoupper($categoriy->shc_cat_name);
                $row[] = strtoupper($categoriy->sh_cat_value);
                $row[] = ' <a class="btn btn-xs btn-blue" href="#" data-toggle="modal" onclick="category_edit('.$categoriy->shc_cat_id.')"><i class="glyphicon fa fa-edit"></i></a>
                <a class="btn btn-xs '.$k.'" href="#" data-toggle="modal" onclick="change_status('.$categoriy->shc_cat_id.','.$categoriy->sh_cat_status.')"><i class="glyphicon fa '.$m.'"></i></a>
                <a class="btn btn-xs btn-bricky" href="#" data-toggle="modal" onclick="perm_delete('.$categoriy->shc_cat_id.')"><i class="glyphicon fa fa-trash-o"></i></a>';
                $data[] = $row;
            }
            $output = array('data' =>$data);
            echo json_encode($output);
        }else{
            $output = array('data' =>'');
            echo json_encode($output);
        }
    }

    public function category_change_status()
    {
           if($this->Shipping_Category_Models->category_change_status($this->input->post('cat_id'),$this->input->post('status'))) {
                   $st = array('status' =>1,'validation' =>'Done!');
                   echo json_encode($st);
           }else {
                   $st = array('status' =>0,'validation' =>'error occurred please contact your system administrator');
                   echo json_encode($st);
           }
    }

    public function category_permanent_delete()
    {
           if($this->Shipping_Category_Models->category_permanent_delete($this->input->post('cat_id'))) {

                   $st = array('status' =>1,'validation' =>'Done!');
                   echo json_encode($st);

           }else {

                   $st = array('status' =>0,'validation' =>'cannot delete parent category with children categorys existing');
                   echo json_encode($st);
           }
    }

    //sub category module function begin


  

   

}