<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Salary extends CI_Controller {

    function __construct() {
        parent::__construct();
        $this->load->model('Salary_model');
        $this->load->model('Salary_type_model');
        $this->load->model('User_model');
        $this->load->model('Common_Model');
		$this->load->model('Warehouse_Model');
		 $this->load->model('Salary_payment_model');
		
		
    }

    var $main_menu_name = 'pay_role';
    var $sub_menu_name = 'salary';

    public function index() {
        $data['main_menu_name'] = $this->main_menu_name;
        $data['sub_menu_name'] = $this->sub_menu_name;
		 $data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
        $this->load->view("salary", $data);
    }
	
    public function summary() {
        $data['main_menu_name'] = $this->main_menu_name;
        $data['sub_menu_name'] = 'salary_summary';
		$data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
        $this->load->view("salary_summary", $data);
    }

public function get_salary_summary_list() {
		
		$search_key=$this->input->post('search');

	$search_key_val=$search_key['value'];

	$start=$this->input->post('start');

	$length=$this->input->post('length');
	$warehouse_id=$this->input->post('warehouse_id');
	$srh_user_id=$this->input->post('srh_user_id');
	$srh_from_date=$this->input->post('srh_from_date');
	$srh_to_date=$this->input->post('srh_to_date');
	
	//print_r($this->input->post('srh_user_id'));
	
	
        $salary_list = $this->Salary_model->get_salary_list($start,$length,$search_key_val,$srh_user_id,$warehouse_id,$srh_from_date,$srh_to_date);
		$salary_list_count = $this->Salary_model->get_salary_list('','',$search_key_val,$srh_user_id,$warehouse_id,$srh_from_date,$srh_to_date);
		
		$totalData=count($salary_list_count);
		$totalFiltered = $totalData; 

        $data = array();
		$balance_amount=0;
        foreach ($salary_list as $row) {
            $nestedData = array();
			// $nestedData[] = $row['sl_id'];
            $nestedData[] = $row['reference_number'];
			   $nestedData[] = $row['user_first_name'].' '.$row['user_last_name'];
			 $nestedData[] = $row['mstr_sal_type_name'];
			  $nestedData[] = $row['sl_note'];
            $nestedData[] = $row['sl_date'];
           
            
            $status = '';
			$addtion_amount='';
			$diduction_amount='';
			
			
            if ($row['mstr_sal_type_did_add'] == 1) {
				$addtion_amount=number_format($row['sl_amount'], 2, '.', '');
				$balance_amount=$balance_amount+$addtion_amount;
               // $status = '<center><span class="label label-success">Addition</span></center>';
            } else if ($row['mstr_sal_type_did_add'] == 0) {
				$diduction_amount=number_format($row['sl_amount'], 2, '.', '');
				$balance_amount=$balance_amount-$diduction_amount;
               // $status = '<center><span class="label label-warning">Deduction</span></center>';
            }

            $nestedData[] = $addtion_amount;
			$nestedData[] = $diduction_amount;
			$nestedData[] = '';//number_format($balance_amount, 2, '.', '');;           
           // $nestedData[] = '';
            $data[] = $nestedData;
        }
		
		
		
		
		//get start payment lsit
		$salary_payment_list = $this->Salary_payment_model->get_salary_payment_list($start, $length, $search_key_val, $srh_user_id, $warehouse_id, $srh_from_date, $srh_to_date);
		//echo $this->db->last_query();
        $salary_payment_list_count = $this->Salary_payment_model->get_salary_payment_list('', '', $search_key_val, $srh_user_id, $warehouse_id, $srh_from_date, $srh_to_date);

        $totalData_2 = $salary_payment_list_count;
        $totalFiltered_2 = $totalData_2;

        //$data = array();
        $balance_amount = 0;
        foreach ($salary_payment_list as $row) {
			//echo "1,";
            $nestedData = array();
			if ($row['sp_is_sal_advance'] == 0) {
                $type = 'Salary';
            } elseif ($row['sp_is_sal_advance'] == 1) {
                $type = 'Advance';
            }
            $nestedData[] = $row['sp_refno'];
            $nestedData[] = $row['user_first_name'] . ' ' . $row['user_last_name'];
			$nestedData[] =$type;
			$nestedData[] =$row['sp_note'];
            $nestedData[] = $row['sp_date'];
            $nestedData[] = '';
            $nestedData[] = number_format($row['sp_amount'], 2, '.', '');
			
			
            $nestedData[] = '';
          
            //$nestedData[] ='';

            $data[] = $nestedData;
        }
		
		//get end payment lsit
		
		
		//$totalData=$totalData+$totalData_2;
		//$totalFiltered=$totalFiltered+$totalFiltered_2;

        $json_data = array(
			//"draw"            => intval( $requestData['draw'] ),  
			"recordsTotal"    => intval( $totalData ),  
			"recordsFiltered" => intval( $totalFiltered ),
			"data"            => $data 
			);




        echo json_encode($json_data);
    }
	
    public function get_salary_list() {
		
		$search_key=$this->input->post('search');

	$search_key_val=$search_key['value'];

	$start=$this->input->post('start');

	$length=$this->input->post('length');
	$warehouse_id=$this->input->post('warehouse_id');
	$srh_user_id=$this->input->post('srh_user_id');
	$srh_from_date=$this->input->post('srh_from_date');
	$srh_to_date=$this->input->post('srh_to_date');
	
	//print_r($this->input->post('srh_user_id'));
	
	
        $salary_list = $this->Salary_model->get_salary_list($start,$length,$search_key_val,$srh_user_id,$warehouse_id,$srh_from_date,$srh_to_date);
		$salary_list_count = $this->Salary_model->get_salary_list('','',$search_key_val,$srh_user_id,$warehouse_id,$srh_from_date,$srh_to_date);
		
		$totalData=count($salary_list_count);
		$totalFiltered = $totalData; 

        $data = array();
		$balance_amount=0;
        foreach ($salary_list as $row) {
            $nestedData = array();
			// $nestedData[] = $row['sl_id'];
            $nestedData[] = $row['reference_number'];
			   $nestedData[] = $row['user_first_name'].' '.$row['user_last_name'];
			 $nestedData[] = $row['mstr_sal_type_name'];
			  $nestedData[] = $row['sl_note']." ($row[sal_remark])";;
           // $nestedData[] = number_format($row['sl_amount'],2);
            $nestedData[] = $row['sl_date'];
           
            
            $status = '';
			$addtion_amount='';
			$diduction_amount='';
			
			
            if ($row['mstr_sal_type_did_add'] == 1) {
				$addtion_amount=number_format($row['sl_amount'], 2, '.', '');
				$balance_amount=$balance_amount+$addtion_amount;
               // $status = '<center><span class="label label-success">Addition</span></center>';
            } else if ($row['mstr_sal_type_did_add'] == 0) {
				$diduction_amount=number_format($row['sl_amount'], 2, '.', '');
				$balance_amount=$balance_amount-$diduction_amount;
               // $status = '<center><span class="label label-warning">Deduction</span></center>';
            }

            $nestedData[] = $addtion_amount;
			 $nestedData[] = $diduction_amount;
			  $nestedData[] = number_format($balance_amount, 2, '.', '');;
            
         

          //  $nestedData[] = $row['sl_added_datetime'];




            $actionTxtUpdate = '<a onClick="click_salary_btn(' . $row['sl_id'] . ')" data-toggle="modal" href="#" class="btn btn-xs btn-blue tooltips" data-placement="top" data-original-title="Edit suppliers"><i class="glyphicon fa fa-edit"></i></a> &nbsp;';
			$actionTxtDelete = '';
			if($this->session->userdata('ss_group_id')==1 || $this->session->userdata('ss_group_id')==2)
			{
            $actionTxtDelete = '<a class="btn btn-xs btn-bricky tooltips" data-placement="top" data-original-title="Delete supplier" onClick="deleteSalaryData(' . $row['sl_id'] . ')">
															<i class="glyphicon fa fa-trash-o"></i></a>';
			}
            $nestedData[] = $actionTxtUpdate . $actionTxtDelete;

            $data[] = $nestedData;
        }

        $json_data = array(
			//"draw"            => intval( $requestData['draw'] ),  
			"recordsTotal"    => intval( $totalData ),  
			"recordsFiltered" => intval( $totalFiltered ),
			"data"            => $data 
			);




        echo json_encode($json_data);
    }

    public function create_salary() {
        if (isset($_GET['mstr_sal_id'])) {
            $sal_id = $_GET['mstr_sal_id'];
        } else {
            $sal_id = '';
        }


        if ($sal_id) {
            $data['salary_id'] = $sal_id;
            $data['type'] = 'E';
            $data['pageName'] = 'UPDATE SALARY';
            $data['btnText'] = 'Update Salary';
            $data['salary_byid'] = $this->Salary_model->get_salary_details($sal_id);
        } else {
            $data['salary_id'] = '';
            $data['type'] = 'A';
            $data['pageName'] = 'ADD SALARY';
            $data['btnText'] = 'Add Salary';
            $data['salary_byid'] = array();
        }

        $this->load->view("models/create_salary", $data);
    }

    public function save_salary() {
        $salary_id = $this->input->post('salary_id');
		
//        echo $salary_id;
        $type = $this->input->post('type');
//        $mstr_sal_type_id = $this->input->post('mstr_sal_type_id');
        $temp_sal_type = explode("_", $this->input->post("mstr_sal_type_id"));
        $mstr_sal_type_id = $temp_sal_type[0];
        $mstr_sal_type_did_add = $temp_sal_type[1];
//        $mstr_sal_type_did_add = $this->input->post('mstr_sal_type_did_add');
        $user_id = $this->input->post('user_id');
        $sl_amount = $this->input->post('sl_amount');
        $sl_date = date('Y-m-d', strtotime($this->input->post("sl_date")));
        $sl_note = $this->input->post('sl_note');
        
        if($type == 'A'){
				//start get next referance no
				$warehouse_id=$this->session->userdata('ss_warehouse_id');
				//echo "warehouse_id:$warehouse_id";
				$warehouse_dtls=$this->Warehouse_Model->get_warehouse_info($warehouse_id);
				//print_r($warehouse_dtls);
				$warehouse_code=$warehouse_dtls['code'];
				$warehouse_last_id=(1+$this->Common_Model->get_next_warehouse_ref_no($warehouse_id,'warehouse_id','warehouse_last_id','salary'));
				
				//
				$reference_number=$warehouse_code.'/SLR/'.sprintf("%04d",$warehouse_last_id);
				//end get next referance no
				
				//echo "reference_number:$reference_number";
			
            //$max_reference = $this->Salary_model->get_max_reference(); //for create next reference number
       // if (isset($max_reference['reference_number'])) {
          //  $next_ref = preg_match_all('!\d+!', $max_reference['reference_number'], $matches);
          //  $next_ref = $matches[0][0] + 1;
          //  $ref = "D/" . sprintf('%04d', $next_ref);
     //   } else {
           // $ref = "D/0001";
        //}
        }

        


        $this->load->library('form_validation'); //form validation lib

        if ($type == 'A') {
            $this->form_validation->set_rules('mstr_sal_type_id', 'mstr_sal_type_did_add', 'user_id', 'sl_amount', 'sl_note', 'sl_date', 'required');
        } else if ($type == 'E') {
            $this->form_validation->set_rules('salary_t_name', 'required');
        }

        if ($this->form_validation->run() == FALSE) {
            $st = array('status' => 0, 'validation' => validation_errors());
            echo json_encode($st);
        } else {
            if($type == 'A'){
//                echo 'add';
                $data = array(
                'reference_number' => $reference_number,
				 'warehouse_last_id' => $warehouse_last_id,
				 'warehouse_id' => $warehouse_id,
                'mstr_sal_type_id' => $mstr_sal_type_id,
                'mstr_sal_type_did_add' => $mstr_sal_type_did_add,
                'user_id' => $user_id,
                'sl_amount' => $sl_amount,
                'sl_date' => $sl_date,
                'sl_note' => $sl_note,
                'added_user' => $this->session->userdata('ss_user_id')
            );
            }else if($type == 'E'){
//                echo 'edit';
                $data = array(
                'mstr_sal_type_id' => $mstr_sal_type_id,
                'mstr_sal_type_did_add' => $mstr_sal_type_did_add,
                'user_id' => $user_id,
                'sl_amount' => $sl_amount,
                'sl_date' => $sl_date,
                'sl_note' => $sl_note,
                'added_user' => $this->session->userdata('ss_user_id')
            );
            }
            

            $this->Salary_model->save_salary($salary_id, $data);

            $lastid = $this->db->insert_id();

            if ($type == 'A') {
                if ($lastid) {
                    echo json_encode(array('id' => $salary_id, 'type' => $type, 'status' => 1));
                } else {
                    echo json_encode(array('status' => 0));
                }
            }
            if ($type == 'E') {
                echo json_encode(array('type' => $type, 'status' => 1));
            }
        }
    }

    public function delete() {
        $id = $this->input->post('id');
        $this->Salary_model->delete_salary($id);
        if ($id) {
            echo json_encode(array('id' => $id));
        } else {
            echo json_encode(array('status' => 'error'));
        }
    }
	
	 public function finalize_salary() {
        $user_id = $this->input->post('user_id');
		$month_id = $this->input->post('month_id');
		$warehouse_id=$this->input->post('srh_warehouse_id');
		$month_name=$this->input->post('month_name');
		$srh_fd_date=date('Y-m-d',strtotime($this->input->post('srh_fd_date')));
		$warehouse_dtls=$this->Warehouse_Model->get_warehouse_info($warehouse_id);
		$status=1;
		$testing='1';
		if($this->session->userdata('ss_user_id')==1) {
			//$testing='';
		}
		$testing='';
        
		$user_list=$this->User_model->getUsers(1,$user_id);
		$return_msg="<table class=\"sl_des_table\"><tr><td width='50px'><strong>#</strong></td><td><strong>Name</strong></td><td><strong>Amount</strong><td><td><strong>Note</strong><td></tr>";
		$user_count=0;
		foreach ($user_list as $user) {
			$user_id=$user->user_id;
			$user_name=$user->user_first_name;
			$user_last_name=$user->user_last_name;
			$mstr_sal_type_id=17;//Basic Salary
			
			/*user_basic_salary start*/
			$user_basic_salary=$user->user_basic_salary;
			if($user_basic_salary!='0.00'){
				$warehouse_code=$warehouse_dtls['code'];
				$warehouse_last_id=(1+$this->Common_Model->get_next_warehouse_ref_no($warehouse_id,'warehouse_id','warehouse_last_id','salary'));
				$reference_number=$warehouse_code.'/SLR/'.sprintf("%04d",$warehouse_last_id);	
				$sl_note="$month_name Month Basic Salary";	
				 $commi_data = array(
                'reference_number' => $reference_number,
				 'warehouse_last_id' => $warehouse_last_id,
				 'warehouse_id' => $warehouse_id,
                'mstr_sal_type_id' => $mstr_sal_type_id,
                'mstr_sal_type_did_add' => 1,
                'user_id' => $user_id,
                'sl_amount' => $user_basic_salary,
                'sl_date' => $srh_fd_date,
				'issue_card_id' => '',
                'sl_note' => $sl_note,
                'added_user' => $this->session->userdata('ss_user_id')
           		 );
				
				//check is added this month
				$is_added=$this->Salary_model->check_is_added_for_selected_month($user_id,$mstr_sal_type_id,$month_id);
				if(!$is_added){
					if(!$testing) $this->Salary_model->save_salary('',$commi_data);
				}else{
					$sl_note="<span style=\"color:#d9534f\">Allredy Added $sl_note: $is_added</span>";
					//$user_basic_salary=0;
				}
					$user_count++;
					$return_msg.="<tr><td>$user_count. </td><td> $user_name $user_last_name</td><td>$user_basic_salary<td><td>$sl_note<td></tr>"; 	
			}
			/*user_basic_salary end*/
			
			/*user_other_allowance start*/
			$user_other_allowance=$user->user_other_allowance;
			$mstr_sal_type_id=18;// Basic Allowance allowance
			//$type_name="";
			if($user_other_allowance!='0.00'){
				$warehouse_code=$warehouse_dtls['code'];
				$warehouse_last_id=(1+$this->Common_Model->get_next_warehouse_ref_no($warehouse_id,'warehouse_id','warehouse_last_id','salary'));
				$reference_number=$warehouse_code.'/SLR/'.sprintf("%04d",$warehouse_last_id);	
				$sl_note="$month_name Month Basic Allowance";			
				 $commi_data = array(
                'reference_number' => $reference_number,
				 'warehouse_last_id' => $warehouse_last_id,
				 'warehouse_id' => $warehouse_id,
                'mstr_sal_type_id' => $mstr_sal_type_id,
                'mstr_sal_type_did_add' => 1,
                'user_id' => $user_id,
                'sl_amount' => $user_other_allowance,
                'sl_date' => $srh_fd_date,
				'issue_card_id' => '',
                'sl_note' => $sl_note,
                'added_user' => $this->session->userdata('ss_user_id')
           		 );
					//check is added this month
				$is_added=$this->Salary_model->check_is_added_for_selected_month($user_id,$mstr_sal_type_id,$month_id);
				if(!$is_added){
					if(!$testing) $this->Salary_model->save_salary('',$commi_data);
				}else{
					$sl_note="<span style=\"color:#d9534f\">Allredy Added $sl_note: $is_added</span>";
					//$user_other_allowance=0;
				}
					$user_count++;
					$return_msg.="<tr><td>$user_count. </td><td> $user_name $user_last_name</td><td>$user_other_allowance<td><td>$sl_note<td></tr>"; 	
			}
			/*user_other_allowance end*/
			
			
			/*user_food_allowance start*/
			$user_food_allowance=$user->user_food_allowance;
			$mstr_sal_type_id=27;// user_food_allowance
			//$type_name="";
			if($user_food_allowance!='0.00'){
				$warehouse_code=$warehouse_dtls['code'];
				$warehouse_last_id=(1+$this->Common_Model->get_next_warehouse_ref_no($warehouse_id,'warehouse_id','warehouse_last_id','salary'));
				$reference_number=$warehouse_code.'/SLR/'.sprintf("%04d",$warehouse_last_id);	
				$sl_note="$month_name Month Food Allowance";			
				 $commi_data = array(
                'reference_number' => $reference_number,
				 'warehouse_last_id' => $warehouse_last_id,
				 'warehouse_id' => $warehouse_id,
                'mstr_sal_type_id' => $mstr_sal_type_id,
                'mstr_sal_type_did_add' => 1,
                'user_id' => $user_id,
                'sl_amount' => $user_food_allowance,
                'sl_date' => $srh_fd_date,
				'issue_card_id' => '',
                'sl_note' => $sl_note,
                'added_user' => $this->session->userdata('ss_user_id')
           		 );
					//check is added this month
				$is_added=$this->Salary_model->check_is_added_for_selected_month($user_id,$mstr_sal_type_id,$month_id);
				if(!$is_added){
					if(!$testing) $this->Salary_model->save_salary('',$commi_data);
				}else{
					$sl_note="<span style=\"color:#d9534f\">Allredy Added $sl_note: $is_added</span>";
					//$user_other_allowance=0;
				}
					$user_count++;
					$return_msg.="<tr><td>$user_count. </td><td> $user_name $user_last_name</td><td>$user_food_allowance<td><td>$sl_note<td></tr>"; 	
			}
			/*user_food_allowance end*/
			
			
			/* user_attendance_allowance start*/
			$user_attendance_allowance=$user->user_attendance_allowance;
			$mstr_sal_type_id=28;// user_food_allowance
			//$type_name="";
			if($user_attendance_allowance!='0.00'){
				$warehouse_code=$warehouse_dtls['code'];
				$warehouse_last_id=(1+$this->Common_Model->get_next_warehouse_ref_no($warehouse_id,'warehouse_id','warehouse_last_id','salary'));
				$reference_number=$warehouse_code.'/SLR/'.sprintf("%04d",$warehouse_last_id);	
				$sl_note="$month_name Month Attendance Allowance";			
				 $commi_data = array(
                'reference_number' => $reference_number,
				 'warehouse_last_id' => $warehouse_last_id,
				 'warehouse_id' => $warehouse_id,
                'mstr_sal_type_id' => $mstr_sal_type_id,
                'mstr_sal_type_did_add' => 1,
                'user_id' => $user_id,
                'sl_amount' => $user_attendance_allowance,
                'sl_date' => $srh_fd_date,
				'issue_card_id' => '',
                'sl_note' => $sl_note,
                'added_user' => $this->session->userdata('ss_user_id')
           		 );
					//check is added this month
				$is_added=$this->Salary_model->check_is_added_for_selected_month($user_id,$mstr_sal_type_id,$month_id);
				if(!$is_added){
					if(!$testing) $this->Salary_model->save_salary('',$commi_data);
				}else{
					$sl_note="<span style=\"color:#d9534f\">Allredy Added $sl_note: $is_added</span>";
					//$user_other_allowance=0;
				}
					$user_count++;
					$return_msg.="<tr><td>$user_count. </td><td> $user_name $user_last_name</td><td>$user_attendance_allowance<td><td>$sl_note<td></tr>"; 	
			}
			/*user_attendance_allowance end*/
	
			
			
			/*ESD start*/
			if($user->user_esd_avalable){
			//$user_other_allowance=$user->user_other_allowance;
			$mstr_sal_type_id=15;//Basic Allowance
			$employee_esd_contribution=floatval($this->Common_Model->get_setting_des_by_sett_name('employee_esd_contribution'));
			//$type_name="";
			if($employee_esd_contribution){
				$warehouse_code=$warehouse_dtls['code'];
				$warehouse_last_id=(1+$this->Common_Model->get_next_warehouse_ref_no($warehouse_id,'warehouse_id','warehouse_last_id','salary'));
				$reference_number=$warehouse_code.'/SLR/'.sprintf("%04d",$warehouse_last_id);	
				$sl_note="$month_name Month ESD Contribution";			
				 $commi_data = array(
                'reference_number' => $reference_number,
				 'warehouse_last_id' => $warehouse_last_id,
				 'warehouse_id' => $warehouse_id,
                'mstr_sal_type_id' => $mstr_sal_type_id,
                'mstr_sal_type_did_add' => 1,
                'user_id' => $user_id,
                'sl_amount' => $user_other_allowance,
                'sl_date' => $srh_fd_date,
				'issue_card_id' => '',
                'sl_note' => $sl_note,
                'added_user' => $this->session->userdata('ss_user_id')
           		 );
					//check is added this month
				$is_added=$this->Salary_model->check_is_added_for_selected_month($user_id,$mstr_sal_type_id,$month_id);
				if(!$is_added){
					if(!$testing) $this->Salary_model->save_salary('',$commi_data);
				}else{
					$sl_note="<span style=\"color:#d9534f\">Allredy Added $sl_note: $is_added</span>";
					//$employee_esd_contribution=0;
				}
					$employee_esd_contribution=number_format($employee_esd_contribution, 2, '.', '');
					$user_count++;
					$return_msg.="<tr><td>$user_count. </td><td> $user_name $user_last_name</td><td>$employee_esd_contribution<td><td>$sl_note<td></tr>"; 	
			}
		}//check avalable
			/*ESD end*/
			
			
			if($user->user_epf_avalable){
			/*Employee EPF Contribution 8% start*/
			//$employee_epf=$employee_epf;
			$amount_for_create_epf=0;
			$amount_for_create_epf=$user_basic_salary;
			if(!$user_basic_salary){
				//get seeing table epf
				$amount_for_create_epf=floatval($this->Common_Model->get_setting_des_by_sett_name('amount_for_create_epf_with_out_basic_salary'));
			}
			$employee_epf_presantage=floatval($this->Common_Model->get_setting_des_by_sett_name('employee_epf_presantage'));
			$employee_epf=$amount_for_create_epf*$employee_epf_presantage/100;
			//echo "employee_epf_presantage:$employee_epf_presantage";
			//$employee_epf=111;
			$mstr_sal_type_id=19;//Basic Allowance
			if($employee_epf!='0.00'){
				$warehouse_code=$warehouse_dtls['code'];
				$warehouse_last_id=(1+$this->Common_Model->get_next_warehouse_ref_no($warehouse_id,'warehouse_id','warehouse_last_id','salary'));
				$reference_number=$warehouse_code.'/SLR/'.sprintf("%04d",$warehouse_last_id);	
				$sl_note="$month_name Month Employee EPF";			
				 $commi_data = array(
                'reference_number' => $reference_number,
				 'warehouse_last_id' => $warehouse_last_id,
				 'warehouse_id' => $warehouse_id,
                'mstr_sal_type_id' => $mstr_sal_type_id,
                'mstr_sal_type_did_add' => 0,
                'user_id' => $user_id,
                'sl_amount' => $employee_epf,
                'sl_date' => $srh_fd_date,
				'issue_card_id' => '',
                'sl_note' => $sl_note,
                'added_user' => $this->session->userdata('ss_user_id')
           		 );
					//check is added this month
				$is_added=$this->Salary_model->check_is_added_for_selected_month($user_id,$mstr_sal_type_id,$month_id);
				
				if(!$is_added){
					if(!$testing) $this->Salary_model->save_salary('',$commi_data);
				}else{
					$sl_note="<span style=\"color:#d9534f\">Allredy Added $sl_note: $is_added</span>";
				}
					$user_count++;
					$employee_epf=number_format($employee_epf, 2, '.', '');
					$return_msg.="<tr><td>$user_count. </td><td> $user_name $user_last_name</td><td>$employee_epf<td><td>$sl_note<td></tr>"; 
				}
				
				///*Employee EPF Contribution end*/
				
				
				
				/*Employer EPF Contribution 12% start*/
			//$employee_epf=$employee_epf;
			$amount_for_create_epf=0;
			$amount_for_create_epf=$user_basic_salary;
			if(!$user_basic_salary){
				//get seeing table epf
				$amount_for_create_epf=floatval($this->Common_Model->get_setting_des_by_sett_name('amount_for_create_epf_with_out_basic_salary'));
			}
			$employer_epf_presantage=floatval($this->Common_Model->get_setting_des_by_sett_name('employer_epf_presantage'));
			$employer_epf=$amount_for_create_epf*$employer_epf_presantage/100;
			//echo "amount_for_create_epf:$amount_for_create_epf";
			
			$mstr_sal_type_id=21;//Basic Allowance
			if($employer_epf!='0.00'){
				$warehouse_code=$warehouse_dtls['code'];
				$warehouse_last_id=(1+$this->Common_Model->get_next_warehouse_ref_no($warehouse_id,'warehouse_id','warehouse_last_id','salary'));
				$reference_number=$warehouse_code.'/SLR/'.sprintf("%04d",$warehouse_last_id);	
				$sl_note="$month_name Month Employer EPF";			
				 $commi_data = array(
                'reference_number' => $reference_number,
				 'warehouse_last_id' => $warehouse_last_id,
				 'warehouse_id' => $warehouse_id,
                'mstr_sal_type_id' => $mstr_sal_type_id,
                'mstr_sal_type_did_add' => 2,
                'user_id' => $user_id,
                'sl_amount' => $employer_epf,
                'sl_date' => $srh_fd_date,
				'issue_card_id' => '',
                'sl_note' => $sl_note,
                'added_user' => $this->session->userdata('ss_user_id')
           		 );
					//check is added this month
				$is_added=$this->Salary_model->check_is_added_for_selected_month($user_id,$mstr_sal_type_id,$month_id);
				
				if(!$is_added){
					if(!$testing) $this->Salary_model->save_salary('',$commi_data);
				}else{
					$sl_note="<span style=\"color:#d9534f\">Allredy Added $sl_note: $is_added</span>";
					//$employer_epf=0;
				}
					$user_count++;
					$employer_epf=number_format($employer_epf, 2, '.', '');
					$return_msg.="<tr><td>$user_count. </td><td> $user_name $user_last_name</td><td>$employer_epf<td><td>$sl_note<td></tr>"; 
				}
				//END Employer EPF
				
				
				/*Employer ETF Contribution 3% start*/
			//$employee_epf=$employee_epf;
			$amount_for_create_epf=0;
			$amount_for_create_epf=$user_basic_salary;
			if(!$user_basic_salary){
				//get seeing table epf
				$employer_etf_presantage=floatval($this->Common_Model->get_setting_des_by_sett_name('employer_etf_presantage'));
			}
			$employer_etf_presantage=floatval($this->Common_Model->get_setting_des_by_sett_name('employer_etf_presantage'));
			$employer_etf=$amount_for_create_epf*$employer_etf_presantage/100;
			//echo "amount_for_create_epf:$amount_for_create_epf";
			
			$mstr_sal_type_id=20;//Employer ETF Contribution
			if($employer_epf!='0.00'){
				$warehouse_code=$warehouse_dtls['code'];
				$warehouse_last_id=(1+$this->Common_Model->get_next_warehouse_ref_no($warehouse_id,'warehouse_id','warehouse_last_id','salary'));
				$reference_number=$warehouse_code.'/SLR/'.sprintf("%04d",$warehouse_last_id);	
				$sl_note="$month_name Month Employer ETF";			
				 $commi_data = array(
                'reference_number' => $reference_number,
				 'warehouse_last_id' => $warehouse_last_id,
				 'warehouse_id' => $warehouse_id,
                'mstr_sal_type_id' => $mstr_sal_type_id,
                'mstr_sal_type_did_add' => 2,
                'user_id' => $user_id,
                'sl_amount' => $employer_etf,
                'sl_date' => $srh_fd_date,
				'issue_card_id' => '',
                'sl_note' => $sl_note,
                'added_user' => $this->session->userdata('ss_user_id')
           		 );
					//check is added this month
				$is_added=$this->Salary_model->check_is_added_for_selected_month($user_id,$mstr_sal_type_id,$month_id);
				
				if(!$is_added){
					if(!$testing) $this->Salary_model->save_salary('',$commi_data);
				}else{
					$sl_note="<span style=\"color:#d9534f\">Allredy Added $sl_note: $is_added</span>";
					//$employer_epf=0;
				}
					$user_count++;
					$employer_etf=number_format($employer_etf, 2, '.', '');
					$return_msg.="<tr><td>$user_count. </td><td> $user_name $user_last_name</td><td>$employer_etf<td><td>$sl_note<td></tr>"; 
				}
				//END Employer ETF
				
				
			}//end epf avalable check
			
			
		}
		//print_r($user_list);
		
		$return_msg.='</table>';
        
		
		echo json_encode(array('status' => $status,'return_msg'=>$return_msg));
        
    }
    
    public function getSalary_types(){
        $str = $this->input->get('search_string');
        $result = $this->Salary_type_model->salary_types_list_search($str);
        echo json_encode($result);
    }
    
    public function getUser(){
        $str = $this->input->get('search_string');
        $result = $this->User_model->get_search_user($str);
        echo json_encode($result);
    }

}
