<?php defined('BASEPATH') OR exit('No direct script access allowed');



class Product extends CI_Controller{

    function __construct() {

        parent::__construct();
        $this->load->helper('url');
        $this->load->model('product_model');
		$this->load->model('Home_Model');
        $this->load->library('cart'); 
    }

    public function product_view(){     
		$bodyClass = "single-product full-width extended";
		$data['bodyClass'] =$bodyClass;
		$product_id=$this->input->get('pid');
        $data['sub_category_list'] = $this->Home_Model->get_sub_category_for_homepage();
		$data['category_list'] = $this->Home_Model->get_category_for_homepage();    
		$data['details'] = $this->product_model->get_single_product($product_id);
		$data['product_details'] = $this->product_model->get_product_details($product_id);
		$data['specification'] = $this->product_model->get_single_product_spesification($product_id);
		$data['connectivity'] = $this->product_model->get_single_product_connectivity($product_id);
		$data['accessories'] = $this->product_model->get_single_product_accessories($product_id);
		$data['images'] = $this->product_model->get_image_list($product_id);
		$data['cart'] = $this->cart->contents();
		$data['cart_count'] =count($data['cart'] );
		$data['cart_total'] = $this->cart->total();
        $this->load->view('product/product-details', $data);
    }
	 public function shop(){     
		$cat_id=$this->input->get('cat_id');
		$sub_cat_id=$this->input->get('sub_cat_id');
		$keyword=$this->input->get('s');		 
        $data['sub_category_list'] = $this->Home_Model->get_sub_category_for_homepage();
		$data['category_list'] = $this->Home_Model->get_category_for_homepage();    
		$product_list = $this->product_model->get_shop_product_list($cat_id,$sub_cat_id,$keyword);
		$data['product_list'] =$this->product_model->get_muliti_product($product_list);		
		
		$data['cart'] = $this->cart->contents();
		$data['cart_count'] =count($data['cart'] );
		$data['cart_total'] = $this->cart->total();
        $this->load->view('shop/shop', $data);
    }
    
    

}