<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
require_once('core_model.php');
class Order_Model extends Core_Model {
 
  public $table_config=array(
      'mater_table'=>'order_master',
      'master_table_primary_id'=>'odr_id',
      'master_table_seconrary_id'=>'',
      'item_table'=>'order_items',
      'item_table_primary_id'=>'odri_id',
      'item_table_seconrary_id'=>'odr_id',
      'sub_item_table'=>'order_plan_item',
      'sub_item_table_primary_id'=>'opi_id',
      'sub_item_table_seconrary_id'=>'opm_id',
      );
  
  function __construct() 
  {
    /* Call the Model constructor */
    parent::__construct($this->table_config);
  }

	function save_order($data)
	{
		return $this->save_master_table($data);
	}
	function save_order_item($data)
	{
		return $this->save_item_table($data);
	}
	function get_list_order() {
	    return $this->get_result_mater_record_data();
	}
	public function get_row_order_info($id)
	 {
	     return $this->get_row_array_mater_record_data_by_primary_id($id);
	 }
	public function delete_order($id)
	{
	    return $this->delete_master_table_by_primary_id($id);
	}
	public function delete_order_item($id)
	{
	    return $this->delete_item_table_by_primary_id($id);
	}
	public function disable_order($id)
	{
		$data = array(
			'status' => 0
		);	
	    return $this->update_master_table_by_primary_id($warehouse_id,$data);
	}
	public function enable_order($warehouse_id)
	{
		$data = array(
			'status' => 1
		);	
		return  $this->update_master_table_by_primary_id($warehouse_id,$data);
	}
	public function update_order_master($id,$data)
	{
		return  $this->update_master_table_by_primary_id($id,$data);
	}
	
	function update_order_item($id,$data){
	    	return  $this->update_item_table_by_primary_id($id,$data);
	}
	public function get_order_info($id)
	{
		 $this->db->select("o.*,c.cus_code,c.cus_name,u.user_first_name,u.user_last_name,w.name,w.code,a.mas_name");
        $this->db->from('order_master o');
        $this->db->join("customer c", "c.cus_id = o.odr_customer_id", "inner");
        $this->db->join("user u", "u.user_id = o.odr_sale_rep_id", "inner");
        $this->db->join("warehouses w", "w.id = o.odr_warehouse_id", "inner");
        $this->db->join("master_approval_status a", "a.approval_status_id = o.odr_approval_status", "inner");
        $this->db->where('o.odr_id',$id);
        $query = $this->db->get();
        if ($query->num_rows() > 0) {
            return $query->row_array();
        } else {
            return false;
        }
	}
	public function get_order_type()
	{
		 $this->db->select("o.*");
        $this->db->from('master_order_type o');
        $this->db->where('o.odr_status',1);
        $query = $this->db->get();
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return false;
        }
	}
	
	function get_search_order_price_type($search_key_val,$odr_type,$warehouse_id){
	    $this->db->select("o.*");
        $this->db->from('master_price_type o');
        $this->db->join("order_price_type opt", "opt.pri_type_id = o.pri_type_id", "inner");
        //$this->db->where('opt.odr_type_id',$odr_type);
        $this->db->where("opt.waresouse_id = ".$warehouse_id." AND opt.odr_type_id = ".$odr_type."  AND  o.pri_type_name LIKE '%$search_key_val%'");
        $this->db->group_by('o.pri_type_id');
        $query = $this->db->get();
        return $query->result_array();
	}
	public function get_order_product_price_cost($product_id)
	{
		$this->db->select("p.product_price,p.credit_salling_price,p.wholesale_price,p.product_cost,p.retail_wholesale");
        $this->db->from('product p');
        $this->db->where('p.product_id',$product_id);
        $query = $this->db->get();
        
        if ($query->num_rows() > 0) {
            return $query->row_array();
        } else {
            return false;
        }
	}
	function get_order_item_price_cost($id)
	{
		$this->db->select("p.*");
        $this->db->from('order_items p');
        $this->db->where('p.odri_id',$id);
        $query = $this->db->get();
        if ($query->num_rows() > 0) {
            return $query->row_array();
        } else {
            return false;
        }
	}
	function get_order_total_values($id){
		$this->db->select_sum("p.total_price");
		$this->db->select_sum("p.total_cost");
        $this->db->from('order_items p');
        $this->db->where('p.odr_id',$id);
        $query = $this->db->get();
        $result = $query->row_array();
        if(isset($result['total_cost'])){
            $return_data=array(
                'total_cost'=>$result['total_cost'],
                'total_price'=>$result['total_price']
                );
                return $return_data;
        }else{
            $return_data=array(
                'total_cost'=>0,
                'total_price'=>0
                );
                return $return_data;
        }
	}
	function get_order_product_list($id){
	     $this->db->select("o.*,p.product_name,p.product_code,u.unit_code,p.product_weight");
        $this->db->from('order_items o');
        $this->db->join("product p", "p.product_id = o.product_id", "inner");
        $this->db->join("mstr_unit u", "u.unit_id = p.product_unit", "inner");
        $this->db->where('o.odr_id',$id);
        $this->db->order_by('o.odr_id','desc');
        $query = $this->db->get();
        return $query->result_array();
	}
	public function get_order_list_pp($id){
		 $this->db->select("o.*,c.cus_code,c.cus_name,u.user_first_name,u.user_last_name,w.name,w.code");
        $this->db->from('order_master o');
        $this->db->join("customer c", "c.cus_id = o.odr_customer_id", "inner");
        $this->db->join("user u", "u.user_id = o.odr_sale_rep_id", "inner");
        $this->db->join("warehouses w", "w.id = o.odr_warehouse_id", "inner");
        $this->db->join('user ua', 'ua.user_id = p.approval_by', 'left'); 
        $query = $this->db->get();
        if ($query->num_rows() > 0) {
            return $query->result_array();
        } else {
            return false;
        }
	}
	function get_order_list($start, $length, $search_key_val,$warehouse_id='',$customer_id='',$sale_rep_id='',$from_date='',$to_date=''){
       	$this->db->select("o.*,c.cus_code,c.cus_name,u.user_first_name,u.user_last_name,w.name,w.code,m.mas_name,d.dpn_ref_no,d.added_date_time AS dpn_date_time,d.pickup_status,d.pickup_date_time,d.invoice_status,d.invoice_on");
       	$this->db->select('ua.user_first_name AS approval_user_first_name ,ua.user_last_name AS approval_user_last_name');
       	$this->db->select('s.sale_reference_no,s.sale_id');
        $this->db->from('order_master o');
        $this->db->join("customer c", "c.cus_id = o.odr_customer_id", "inner");
        $this->db->join("user u", "u.user_id = o.odr_sale_rep_id", "inner");
        $this->db->join("warehouses w", "w.id = o.odr_warehouse_id", "inner");
        $this->db->join('master_approval_status m', 'm.approval_status_id = o.odr_approval_status', 'inner');
        $this->db->join('user ua', 'ua.user_id = o.approval_by', 'left'); 
        $this->db->join('dispatch_note_master d', 'd.order_id = o.odr_id', 'left');
        $this->db->join('sales s', 's.card_ref_number = d.dpn_ref_no', 'left');
        if ($search_key_val) {
            $quary='';
            if($warehouse_id){
              $quary.=' AND o.odr_warehouse_id = '.$warehouse_id; 
            }
             if($customer_id){
              $quary.=' AND o.odr_customer_id = '.$customer_id;  
            }
            if($sale_rep_id){
              $quary.=' AND o.odr_sale_rep_id = '.$sale_rep_id; 
            }
             if($from_date){
              $quary.=' AND date(o.order_date_time) >= '.$from_date; 
            }
             if($to_date){
              $quary.=' AND date(o.order_date_time) <= '.$to_date; 
            }
             $this->db->where("o.odr_ref_no LIKE '$search_key_val%'".$quary);
             $this->db->or_where("c.cus_name LIKE '$search_key_val%'".$quary);
        }else{
            if($warehouse_id){
              $this->db->where('o.odr_warehouse_id',$warehouse_id);  
            }
             if($customer_id){
              $this->db->where('o.odr_customer_id',$customer_id);  
            }
            if($sale_rep_id){
              $this->db->where('o.odr_sale_rep_id',$sale_rep_id);  
            }
            
             if($from_date){
              $this->db->where('date(o.order_date_time) >= ',$from_date);  
            }
             if($to_date){
              $this->db->where('date(o.order_date_time) <= ',$to_date);  
            }
        }
		$this->db->order_by("o.odr_id", "desc");
        if ($start != '' && $length != '') {
            $this->db->limit($length, $start);
            $query = $this->db->get();
            if ($query->num_rows() > 0) {
                return $query->result();
            } else {
                return false;
            }
        } else {
            $query = $this->db->get();
            if ($query->num_rows() > 0) {
                return $query->num_rows();
            } else {
                return false;
            }
        }
    }
	function get_order_approval_pending_list($start, $length, $search_key_val,$warehouse_id='',$customer_id='',$sale_rep_id=''){
       	$this->db->select("o.*,c.cus_code,c.cus_name,u.user_first_name,u.user_last_name,w.name,w.code,m.mas_name");
       	$this->db->select('ua.user_first_name AS approval_user_first_name ,ua.user_last_name AS approval_user_last_name');
        $this->db->from('order_master o');
        $this->db->join("customer c", "c.cus_id = o.odr_customer_id", "inner");
        $this->db->join("user u", "u.user_id = o.odr_sale_rep_id", "inner");
        $this->db->join("warehouses w", "w.id = o.odr_warehouse_id", "inner");
        $this->db->join('master_approval_status m', 'm.approval_status_id = o.odr_approval_status', 'inner');
        $this->db->join('user ua', 'ua.user_id = o.approval_by', 'left'); 
        if ($search_key_val) {
             $quary='';
            if($warehouse_id){
              $quary.=' AND o.odr_warehouse_id = '.$warehouse_id; 
            }
             if($customer_id){
              $quary.=' AND o.odr_customer_id = '.$customer_id;  
            }
            if($sale_rep_id){
              $quary.=' AND o.odr_sale_rep_id = '.$sale_rep_id; 
            }
            
             $this->db->where("o.odr_credit_approval_status = 1 AND o.odr_approval_status = 0 AND o.odr_status = 1 AND o.odr_ref_no LIKE '$search_key_val%'".$quary);
             $this->db->or_where("o.odr_credit_approval_status = 1 AND o.odr_approval_status = 0 AND o.odr_status = 1 AND c.cus_name LIKE '$search_key_val%'".$quary);
        }else{
                $this->db->where("o.odr_credit_approval_status = 1 AND o.odr_approval_status = 0 AND o.odr_status = 1");
                
            if($warehouse_id){
              $this->db->where('o.odr_warehouse_id',$warehouse_id);  
            }
             if($customer_id){
              $this->db->where('o.odr_customer_id',$customer_id);  
            }
            if($sale_rep_id){
              $this->db->where('o.odr_sale_rep_id',$sale_rep_id);  
            }
        }
		$this->db->order_by("o.odr_id", "desc");
        if ($start != '' && $length != '') {
            $this->db->limit($length, $start);
            $query = $this->db->get();
            if ($query->num_rows() > 0) {
                return $query->result();
            } else {
                return false;
            }
        } else {
            $query = $this->db->get();
            if ($query->num_rows() > 0) {
                return $query->num_rows();
            } else {
                return false;
            }
        }
    }
    function get_order_approved_pending_pickup_list($warehouse_id='')
    {
       	$this->db->select("o.*,c.cus_code,c.cus_name,u.user_first_name,u.user_last_name,w.name,w.code,m.mas_name");
       	$this->db->select('ua.user_first_name AS approval_user_first_name ,ua.user_last_name AS approval_user_last_name');
        $this->db->from('order_master o');
        $this->db->join("customer c", "c.cus_id = o.odr_customer_id", "inner");
        $this->db->join("user u", "u.user_id = o.odr_sale_rep_id", "inner");
        $this->db->join("warehouses w", "w.id = o.odr_warehouse_id", "inner");
        $this->db->join('master_approval_status m', 'm.approval_status_id = o.odr_approval_status', 'inner');
        $this->db->join('user ua', 'ua.user_id = o.approval_by', 'left'); 
        if($warehouse_id){
            $this->db->where("o.odr_approval_status = 1 AND o.odr_status = 1 AND o.pickup_status = 0 AND o.odr_warehouse_id = ".$warehouse_id);
        }else{
            $this->db->where("o.odr_approval_status = 1 AND o.odr_status = 1 AND o.pickup_status = 0 ");
        }
        
        $this->db->order_by("o.odr_priority", "asc");
		$this->db->order_by("o.odr_id", "asc");
        $query = $this->db->get();
        return $query->result();
    }
    function get_order_approved_pending_pickup_item_list($warehouse_id=''){
       $this->db->select("oi.*,p.product_name,p.product_code,u.unit_code");
        $this->db->from('order_items oi');
        $this->db->join("order_master o", "o.odr_id = oi.odr_id", "inner");
        $this->db->join("product p", "p.product_id = oi.product_id", "inner");
        $this->db->join("mstr_unit u", "u.unit_id = p.product_unit", "inner");
        //$this->db->where("o.odr_approval_status = 1 AND o.odr_status = 1 AND o.pickup_status = 0 ");
        if($warehouse_id){
            $this->db->where("o.odr_approval_status = 1 AND o.odr_status = 1 AND o.pickup_status = 0 AND o.odr_warehouse_id = ".$warehouse_id);
        }else{
            $this->db->where("o.odr_approval_status = 1 AND o.odr_status = 1 AND o.pickup_status = 0 ");
        }
        $this->db->order_by('o.odr_id','asc');
        $query = $this->db->get();
        return $query->result_array();
    }
     function get_order_approved_pending_pickup_products($warehouse_id=''){
       $this->db->select("oi.product_id");
        $this->db->from('order_items oi');
        $this->db->join("order_master o", "o.odr_id = oi.odr_id", "inner");
        //$this->db->where("o.odr_approval_status = 1 AND o.odr_status = 1 AND o.pickup_status = 0 ");
         if($warehouse_id){
            $this->db->where("o.odr_approval_status = 1 AND o.odr_status = 1 AND o.pickup_status = 0 AND o.odr_warehouse_id = ".$warehouse_id);
        }else{
            $this->db->where("o.odr_approval_status = 1 AND o.odr_status = 1 AND o.pickup_status = 0 ");
        }
        $this->db->group_by('oi.product_id');
        $query = $this->db->get();
        return $query->result_array();
    }
    function save_order_plan($data){
		 $this->db->insert('order_plan_master',$data);
		 return $this->db->insert_id();
	}
	function save_order_plan_item($data){
		 $this->db->insert('order_plan_item',$data);
		 return $this->db->insert_id();
	}
	 function get_order_plan_list($start, $length, $search_key_val){
        $this->db->select('p.*,m.mas_name');
        $this->db->select('u.user_first_name AS added_user_first_name ,u.user_last_name AS added_user_last_name');
        $this->db->select('ua.user_first_name AS approval_user_first_name ,ua.user_last_name AS approval_user_last_name');
        $this->db->from('order_plan_master p');
        $this->db->join('master_approval_status m', 'm.approval_status_id = p.opm_approval_status', 'inner');
        $this->db->join('user u', 'u.user_id = p.added_user_id', 'inner');
        $this->db->join('user ua', 'ua.user_id = p.approval_by', 'left'); 
        if ($search_key_val) {
             $this->db->where(" p.prm_ref_no LIKE '$search_key_val%'");
        }else{
    
        }
		$this->db->order_by("p.opm_id", "desc");
        if ($start != '' && $length != '') {
            $this->db->limit($length, $start);
            $query = $this->db->get();
            if ($query->num_rows() > 0) {
                return $query->result();
            } else {
                return false;
            }
        } else {
            $query = $this->db->get();
            if ($query->num_rows() > 0) {
                return $query->num_rows();
            } else {
                return false;
            }
        }
    }
     function get_order_approved_completed_pickup_list($id){
       	$this->db->select("o.*,c.cus_code,c.cus_name,u.user_first_name,u.user_last_name,w.name,w.code,m.mas_name,opm.opm_approval_status");
       	$this->db->select('ua.user_first_name AS approval_user_first_name ,ua.user_last_name AS approval_user_last_name');
        $this->db->from('order_plan_item opi');
        $this->db->join("order_plan_master opm", "opm.opm_id = opi.opm_id", "inner");
        $this->db->join("order_master o", "o.odr_id = opi.order_id", "inner");
        $this->db->join("customer c", "c.cus_id = o.odr_customer_id", "inner");
        $this->db->join("user u", "u.user_id = o.odr_sale_rep_id", "inner");
        $this->db->join("warehouses w", "w.id = o.odr_warehouse_id", "inner");
        $this->db->join('master_approval_status m', 'm.approval_status_id = o.odr_approval_status', 'inner');
        $this->db->join('user ua', 'ua.user_id = o.approval_by', 'left'); 
        $this->db->where("opi.opm_id",$id);
        $this->db->order_by("o.odr_priority", "asc");
		$this->db->order_by("o.odr_id", "asc");
        $query = $this->db->get();
        return $query->result();
    }
     public function get_order_approved_completed_pickup_item_list($id){
       $this->db->select("oi.*,p.product_name,p.product_code,u.unit_code");
        $this->db->from('order_items oi');
        $this->db->join("order_plan_item o", "o.order_id = oi.odr_id", "inner");
        $this->db->join("product p", "p.product_id = oi.product_id", "inner");
        $this->db->join("mstr_unit u", "u.unit_id = p.product_unit", "inner");
        $this->db->where("o.opm_id",$id);
        $this->db->order_by('o.order_id','asc');
        $query = $this->db->get();
        return $query->result_array();
    }
    public function delete_order_plan_item($id){
	    if($id>0){
	       $this->db->where('order_id', $id);
		return $this->db->delete('order_plan_item'); 
	    }else{
	        return false;
	    }
	}
	 public function update_order_plan_master($id,$data){
	     if($id>0){
	   	$this->db->where('opm_id', $id);
		return $this->db->update('order_plan_master',$data);
	     }else{
	        return false;
	    }
	}
	public function get_planned_order_list($id){
	    $this->db->select("o.*");
        $this->db->from('order_plan_item opi');
        $this->db->join("order_master o", "o.odr_id = opi.order_id", "inner");
        $this->db->where("opi.opm_id",$id);
       $this->db->group_by("o.odr_id");
        $query = $this->db->get();
        return $query->result_array();
	}
	 function get_planned_order_item_list($id){
       $this->db->select("oi.*,p.product_price,p.wholesale_price,p.credit_salling_price,p.product_weight,,p.product_cost,o.price_type_id,p.retail_wholesale");
        $this->db->from('order_items oi');
        $this->db->join("order_master o", "o.odr_id = oi.odr_id", "inner");
        $this->db->join("product p", "p.product_id = oi.product_id", "inner");
        $this->db->where("oi.odr_id",$id);
        $this->db->order_by('o.odr_id','asc');
        $query = $this->db->get();
        return $query->result_array();
    }
	 function save_dispach_note($data){
		 $this->db->insert('dispatch_note_master',$data);
		 return $this->db->insert_id();
	}
	function save_dispach_note_item($data){
		 $this->db->insert('dispatch_note_item',$data);
		 return $this->db->insert_id();
	}
	function get_order_plan_details($id){
        $this->db->select('p.*,m.mas_name');
        $this->db->select('u.user_first_name AS added_user_first_name ,u.user_last_name AS added_user_last_name');
        $this->db->select('ua.user_first_name AS approval_user_first_name ,ua.user_last_name AS approval_user_last_name');
        $this->db->from('order_plan_master p');
        $this->db->join('master_approval_status m', 'm.approval_status_id = p.opm_approval_status', 'inner');
        $this->db->join('user u', 'u.user_id = p.added_user_id', 'inner');
        $this->db->join('user ua', 'ua.user_id = p.approval_by', 'left'); 
        $this->db->where("p.opm_id",$id);
        $query = $this->db->get();
        return $query->row_array();
    }
    public function check_already_added($product_id,$odr_id){
        $this->db->from('order_items o');
        $this->db->where('o.product_id',$product_id);
        $this->db->where('o.odr_id',$odr_id);
        $query = $this->db->get();
        return $query->num_rows() ;
	}
    public function update_dispatch_note($id,$data){
	     if($id>0){
	   	$this->db->where('dpn_id', $id);
		return $this->db->update('dispatch_note_master',$data);
	     }else{
	        return false;
	    }
	}
	function get_loading_unloading_charge(){
	    $this->db->select("o.*");
        $this->db->from('loading_and_unloading_chagers o');
        $this->db->where('o.id',1);
        $query = $this->db->get();
        $result = $query->row_array();
        if(isset($result['unit_qty'])&&isset($result['charge'])){
           return $return_data=array('unit_qty'=>$result['unit_qty'],'charge'=>$result['charge']);
        }else{
            return $return_data=array('unit_qty'=>0,'charge'=>0);
        }
	}
	function check_product_batch_validation($id){
	    $this->db->from('product o');
        $this->db->where('o.product_id',$id);
        $this->db->where('o.is_batch_validate',1);
        $query = $this->db->get();
        return $query->num_rows() ;
	}
    function get_active_batch_list($product_id){
        $this->db->select("o.*");
        $this->db->from('batch_product o');
        $this->db->where('o.product_id',$product_id);
        $this->db->where('o.batch_status',1);
        $query = $this->db->get();
        return $query->result_array() ; 
    }
    function get_batch_details($id){
        $this->db->select("o.*");
        $this->db->from('batch_product o');
        $this->db->where('o.batch_id',$id);
        $query = $this->db->get();
        return $query->row_array() ; 
    }
    function check_batch_validation($id)
	{
		$this->db->from('order_items o');
        $this->db->where('o.odri_id',$id);
        $this->db->where('o.is_batch_validate',1);
        $query = $this->db->get();
        return $query->num_rows() ;
	}
	 function get_order_approved_qty($id)
	{
	    $this->db->select("o.approved_qty");
		$this->db->from('order_items o');
        $this->db->where('o.odri_id',$id);
        $query = $this->db->get();
        $result = $query->row_array() ;
        if(isset($result['approved_qty'])){
            return $result['approved_qty'];
        }else{
            return  0;
        }
	}
	
	function get_order_price_type(){
	    $this->db->select("o.*");
        $this->db->from('master_price_type o');
        $query = $this->db->get();
        return $query->result_array();
	}
	
		function peyment_term(){
	    $this->db->select('pay_term_id,pay_term_name,pay_term_in_days');		
		$query = $this->db->get('master_payment_term');
		 if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return false;
        }
	}
	
	
	function get_credit_term_days($id){
	    $this->db->select("pay_term_in_days");
        $this->db->from('master_payment_term');
        $this->db->where('pay_term_id',$id);
        $query = $this->db->get();
        $result_data= $query->row_array() ; 
        if(isset($result_data['pay_term_in_days'])){
            return  $result_data['pay_term_in_days'];
        }else{
            return 0;
        }
	    
	}
	
		function get_order_list_with_invoice($start, $length, $search_key_val,$warehouse_id='',$customer_id='',$sale_rep_id='',$srh_from_date='',$srh_to_date=''){
       	$this->db->select("o.*,c.cus_code,c.cus_name,u.user_first_name,u.user_last_name,w.name,w.code,m.mas_name,d.dpn_ref_no,d.added_date_time AS dpn_date_time,d.pickup_status,d.pickup_date_time,d.invoice_status,d.invoice_on,d.total_dpn_value");
       	$this->db->select('ua.user_first_name AS approval_user_first_name ,ua.user_last_name AS approval_user_last_name,s.sale_reference_no,s.sale_total,dl.d_ref_no');
        $this->db->from('order_master o');
        $this->db->join("customer c", "c.cus_id = o.odr_customer_id", "inner");
        $this->db->join("user u", "u.user_id = o.odr_sale_rep_id", "inner");
        $this->db->join("warehouses w", "w.id = o.odr_warehouse_id", "inner");
        $this->db->join('master_approval_status m', 'm.approval_status_id = o.odr_approval_status', 'inner');
        $this->db->join('user ua', 'ua.user_id = o.approval_by', 'left'); 
        $this->db->join('dispatch_note_master d', 'd.order_id = o.odr_id', 'left');
        $this->db->join('delivery_master dl', 'dl.d_id = d.delivery_id', 'left');
        $this->db->join('sales s', 's.card_ref_number = d.dpn_ref_no', 'left');
        if ($search_key_val) {
            $quary='';
            if($warehouse_id){
              $quary.=' AND o.odr_warehouse_id = '.$warehouse_id; 
            }
             if($customer_id){
              $quary.=' AND o.odr_customer_id = '.$customer_id;  
            }
            if($sale_rep_id){
              $quary.=' AND o.odr_sale_rep_id = '.$sale_rep_id; 
            }
             $this->db->where("o.odr_ref_no LIKE '$search_key_val%'".$quary);
             $this->db->or_where("c.cus_name LIKE '$search_key_val%'".$quary);
        }else{
            if($warehouse_id){
              $this->db->where('o.odr_warehouse_id',$warehouse_id);  
            }
             if($customer_id){
              $this->db->where('o.odr_customer_id',$customer_id);  
            }
            if($sale_rep_id){
              $this->db->where('o.odr_sale_rep_id',$sale_rep_id);  
            }
            if($srh_from_date){
              $this->db->where('date(order_date_time) >= ', $srh_from_date);  
            }
             if($srh_to_date){
               $this->db->where('date(order_date_time) <= ', $srh_to_date);  
             }
        }
		$this->db->order_by("o.odr_id", "desc");
        if ($start != '' && $length != '') {
            $this->db->limit($length, $start);
            $query = $this->db->get();
            if ($query->num_rows() > 0) {
                return $query->result();
            } else {
                return false;
            }
        } else {
            $query = $this->db->get();
            if ($query->num_rows() > 0) {
                return $query->num_rows();
            } else {
                return false;
            }
        }
    }
    
    
    
    function get_order_credit_approval_pending_list($start, $length, $search_key_val,$warehouse_id='',$customer_id='',$sale_rep_id=''){
       	$this->db->select("o.*,c.cus_code,c.cus_name,u.user_first_name,u.user_last_name,w.name,w.code,m.mas_name,c.cus_credit_limit");
       	$this->db->select('ua.user_first_name AS approval_user_first_name ,ua.user_last_name AS approval_user_last_name');
        $this->db->from('order_master o');
        $this->db->join("customer c", "c.cus_id = o.odr_customer_id", "inner");
        $this->db->join("user u", "u.user_id = o.odr_sale_rep_id", "inner");
        $this->db->join("warehouses w", "w.id = o.odr_warehouse_id", "inner");
        $this->db->join('master_approval_status m', 'm.approval_status_id = o.odr_approval_status', 'inner');
        $this->db->join('user ua', 'ua.user_id = o.approval_by', 'left'); 
        if ($search_key_val) {
             $quary='';
            if($warehouse_id){
              $quary.=' AND o.odr_warehouse_id = '.$warehouse_id; 
            }
             if($customer_id){
              $quary.=' AND o.odr_customer_id = '.$customer_id;  
            }
            if($sale_rep_id){
              $quary.=' AND o.odr_sale_rep_id = '.$sale_rep_id; 
            }
            
             $this->db->where("o.odr_credit_approval_status = 0 AND o.odr_approval_status = 0 AND o.odr_status = 1 AND o.odr_ref_no LIKE '$search_key_val%'".$quary);
             $this->db->or_where("o.odr_credit_approval_status = 0 AND o.odr_approval_status = 0 AND o.odr_status = 1 AND c.cus_name LIKE '$search_key_val%'".$quary);
        }else{
                $this->db->where("o.odr_credit_approval_status = 0 AND o.odr_approval_status = 0 AND o.odr_status = 1");
                
            if($warehouse_id){
              $this->db->where('o.odr_warehouse_id',$warehouse_id);  
            }
             if($customer_id){
              $this->db->where('o.odr_customer_id',$customer_id);  
            }
            if($sale_rep_id){
              $this->db->where('o.odr_sale_rep_id',$sale_rep_id);  
            }
        }
		$this->db->order_by("o.odr_id", "desc");
        if ($start != '' && $length != '') {
            $this->db->limit($length, $start);
            $query = $this->db->get();
            if ($query->num_rows() > 0) {
                return $query->result();
            } else {
                return false;
            }
        } else {
            $query = $this->db->get();
            if ($query->num_rows() > 0) {
                return $query->num_rows();
            } else {
                return false;
            }
        }
    }
    
    public function get_bulk_order_info($id)
	{
		 $this->db->select("o.*,c.cus_code,c.cus_name,u.user_first_name,u.user_last_name,w.name,w.code,a.mas_name");
        $this->db->from('order_master o');
        $this->db->join("customer c", "c.cus_id = o.odr_customer_id", "left");
        $this->db->join("user u", "u.user_id = o.odr_sale_rep_id", "inner");
        $this->db->join("warehouses w", "w.id = o.odr_warehouse_id", "inner");
        $this->db->join("master_approval_status a", "a.approval_status_id = o.odr_approval_status", "inner");
        $this->db->where('o.odr_id',$id);
        $query = $this->db->get();
        if ($query->num_rows() > 0) {
            return $query->row_array();
        } else {
            return false;
        }
	}
	
	function get_bulk_order_list($start, $length, $search_key_val,$warehouse_id='',$customer_id='',$sale_rep_id='',$from_date='',$to_date=''){
       	$this->db->select("o.*,c.cus_code,c.cus_name,u.user_first_name,u.user_last_name,w.name,w.code,m.mas_name,d.dpn_ref_no,d.added_date_time AS dpn_date_time,d.pickup_status,d.pickup_date_time,d.invoice_status,d.invoice_on");
       	$this->db->select('ua.user_first_name AS approval_user_first_name ,ua.user_last_name AS approval_user_last_name');
       	//$this->db->select('s.sale_reference_no,s.sale_id');
        $this->db->from('order_master o');
        $this->db->join("customer c", "c.cus_id = o.odr_customer_id", "left");
        $this->db->join("user u", "u.user_id = o.odr_sale_rep_id", "inner");
        $this->db->join("warehouses w", "w.id = o.odr_warehouse_id", "inner");
        $this->db->join('master_approval_status m', 'm.approval_status_id = o.odr_approval_status', 'inner');
        $this->db->join('user ua', 'ua.user_id = o.approval_by', 'left'); 
        $this->db->join('dispatch_note_master d', 'd.order_id = o.odr_id', 'left');
        if ($search_key_val) {
            $quary='';
            if($warehouse_id){
              $quary.=' AND o.odr_warehouse_id = '.$warehouse_id; 
            }
             if($customer_id){
              $quary.=' AND o.odr_customer_id = '.$customer_id;  
            }
            if($sale_rep_id){
              $quary.=' AND o.odr_sale_rep_id = '.$sale_rep_id; 
            }
             if($from_date){
              $quary.=' AND date(o.order_date_time) >= '.$from_date; 
            }
             if($to_date){
              $quary.=' AND date(o.order_date_time) <= '.$to_date; 
            }
             $this->db->where("o.odr_ref_no LIKE '$search_key_val%'".$quary);
             $this->db->or_where("c.cus_name LIKE '$search_key_val%'".$quary);
        }else{
            if($warehouse_id){
              $this->db->where('o.odr_warehouse_id',$warehouse_id);  
            }
             if($customer_id){
              $this->db->where('o.odr_customer_id',$customer_id);  
            }
            if($sale_rep_id){
              $this->db->where('o.odr_sale_rep_id',$sale_rep_id);  
            }
            
             if($from_date){
              $this->db->where('date(o.order_date_time) >= ',$from_date);  
            }
             if($to_date){
              $this->db->where('date(o.order_date_time) <= ',$to_date);  
            }
            $this->db->where('o.odr_type_id',4);
        }
		$this->db->order_by("o.odr_id", "desc");
        if ($start != '' && $length != '') {
            $this->db->limit($length, $start);
            $query = $this->db->get();
            if ($query->num_rows() > 0) {
                return $query->result();
            } else {
                return false;
            }
        } else {
            $query = $this->db->get();
            if ($query->num_rows() > 0) {
                return $query->num_rows();
            } else {
                return false;
            }
        }
    }
    
    
    function get_bulk_order_approved_pending_pickup_list($warehouse_id='')
    {
       	$this->db->select("o.*,c.cus_code,c.cus_name,u.user_first_name,u.user_last_name,w.name,w.code,m.mas_name");
       	$this->db->select('ua.user_first_name AS approval_user_first_name ,ua.user_last_name AS approval_user_last_name');
        $this->db->from('order_master o');
        $this->db->join("customer c", "c.cus_id = o.odr_customer_id", "left");
        $this->db->join("user u", "u.user_id = o.odr_sale_rep_id", "inner");
        $this->db->join("warehouses w", "w.id = o.odr_warehouse_id", "inner");
        $this->db->join('master_approval_status m', 'm.approval_status_id = o.odr_approval_status', 'inner');
        $this->db->join('user ua', 'ua.user_id = o.approval_by', 'left'); 
        if($warehouse_id){
            $this->db->where("o.odr_approval_status = 1 AND o.odr_status = 1 AND o.pickup_status = 0 AND odr_type_id = 4 AND o.odr_warehouse_id = ".$warehouse_id);
        }else{
            $this->db->where("o.odr_approval_status = 1 AND o.odr_status = 1 AND o.pickup_status = 0 AND odr_type_id = 4 ");
        }
        
        $this->db->order_by("o.odr_priority", "asc");
		$this->db->order_by("o.odr_id", "asc");
        $query = $this->db->get();
        return $query->result();
    }
    
    function get_bulk_order_approved_pending_pickup_item_list($warehouse_id=''){
       $this->db->select("oi.*,p.product_name,p.product_code,u.unit_code");
        $this->db->from('order_items oi');
        $this->db->join("order_master o", "o.odr_id = oi.odr_id", "inner");
        $this->db->join("product p", "p.product_id = oi.product_id", "inner");
        $this->db->join("mstr_unit u", "u.unit_id = p.product_unit", "inner");
        //$this->db->where("o.odr_approval_status = 1 AND o.odr_status = 1 AND o.pickup_status = 0 ");
        if($warehouse_id){
            $this->db->where("o.odr_approval_status = 1 AND o.odr_status = 1 AND o.pickup_status = 0 AND odr_type_id = 4 AND o.odr_warehouse_id = ".$warehouse_id);
        }else{
            $this->db->where("o.odr_approval_status = 1 AND o.odr_status = 1 AND o.pickup_status = 0 AND odr_type_id = 4 ");
        }
        $this->db->order_by('o.odr_id','asc');
        $query = $this->db->get();
        return $query->result_array();
    }
     function get_bulk_order_approved_pending_pickup_products($warehouse_id=''){
       $this->db->select("oi.product_id");
        $this->db->from('order_items oi');
        $this->db->join("order_master o", "o.odr_id = oi.odr_id", "inner");
        //$this->db->where("o.odr_approval_status = 1 AND o.odr_status = 1 AND o.pickup_status = 0 ");
         if($warehouse_id){
            $this->db->where("o.odr_approval_status = 1 AND o.odr_status = 1 AND o.pickup_status = 0 AND odr_type_id = 4  AND o.odr_warehouse_id = ".$warehouse_id);
        }else{
            $this->db->where("o.odr_approval_status = 1 AND o.odr_status = 1 AND o.pickup_status = 0 AND odr_type_id = 4  ");
        }
        $this->db->group_by('oi.product_id');
        $query = $this->db->get();
        return $query->result_array();
    }
    
    function get_bulk_order_plan_list($start, $length, $search_key_val){
        $this->db->select('p.*,m.mas_name');
        $this->db->select('u.user_first_name AS added_user_first_name ,u.user_last_name AS added_user_last_name');
        $this->db->select('ua.user_first_name AS approval_user_first_name ,ua.user_last_name AS approval_user_last_name');
        $this->db->from('order_plan_master p');
        $this->db->join('master_approval_status m', 'm.approval_status_id = p.opm_approval_status', 'inner');
        $this->db->join('user u', 'u.user_id = p.added_user_id', 'inner');
        $this->db->join('user ua', 'ua.user_id = p.approval_by', 'left'); 
        if ($search_key_val) {
             $this->db->where(" p.prm_ref_no LIKE '$search_key_val%'");
        }else{
    
        }
		$this->db->order_by("p.opm_id", "desc");
        if ($start != '' && $length != '') {
            $this->db->limit($length, $start);
            $query = $this->db->get();
            if ($query->num_rows() > 0) {
                return $query->result();
            } else {
                return false;
            }
        } else {
            $query = $this->db->get();
            if ($query->num_rows() > 0) {
                return $query->num_rows();
            } else {
                return false;
            }
        }
    }
    
    function get_bulk_order_approved_completed_pickup_list($id){
       	$this->db->select("o.*,c.cus_code,c.cus_name,u.user_first_name,u.user_last_name,w.name,w.code,m.mas_name,opm.opm_approval_status");
       	$this->db->select('ua.user_first_name AS approval_user_first_name ,ua.user_last_name AS approval_user_last_name');
        $this->db->from('order_plan_item opi');
        $this->db->join("order_plan_master opm", "opm.opm_id = opi.opm_id", "inner");
        $this->db->join("order_master o", "o.odr_id = opi.order_id", "inner");
        $this->db->join("customer c", "c.cus_id = o.odr_customer_id", "left");
        $this->db->join("user u", "u.user_id = o.odr_sale_rep_id", "inner");
        $this->db->join("warehouses w", "w.id = o.odr_warehouse_id", "inner");
        $this->db->join('master_approval_status m', 'm.approval_status_id = o.odr_approval_status', 'inner');
        $this->db->join('user ua', 'ua.user_id = o.approval_by', 'left'); 
        $this->db->where("opi.opm_id",$id);
        $this->db->order_by("o.odr_priority", "asc");
		$this->db->order_by("o.odr_id", "asc");
        $query = $this->db->get();
        return $query->result();
    }
    
    

	
}