<?php
if (!defined('BASEPATH'))
    exit('No direct script access allowed');
   
class Price_Adminstration extends CI_Controller
{
    var $main_menu_name = "price_management";
    var $sub_menu_name = "price_management";
    private $main_model;
   
    public function __construct()
    {
        parent::__construct();
        date_default_timezone_set("Asia/Colombo");
        $this->load->model('common_model');
        $this->load->model('Warehouse_Model');
        $this->load->model('Price_Model');
        $this->load->model('Sys_Settings_Model');
        
    }
    public function index()
    {
       show_404();
    }
    public function new_product_price(){
        $data['main_menu_name'] = 'products';
		$data['sub_menu_name'] = 'new_product_price';
		
		$cat_id=$this->input->get('cat_id');
		$item_cat_id=$this->input->get('item_cat_id');
	    $brand_id=$this->input->get('brand_id');
	    if(!is_numeric($cat_id)){
	        $cat_id='';
	    }
	    if(!is_numeric($item_cat_id)){
	        $item_cat_id='';
	    }
	     if(!is_numeric($brand_id)){
	        $brand_id='';
	    }
		$data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
		$data['price_type_list'] = $this->Price_Model->get_all_price_type();
		$recode_count=$this->Price_Model->get_pending_price_list_count();
		if($recode_count>0){
		 $last_id=$this->Price_Model->get_price_list_last_id();
		 $data['status']=1; 
		 $price_list=$this->Price_Model->get_price_item_list($last_id);
         $product_list=$this->Price_Model->get_price_item_list_product_group_wise($last_id,$cat_id,$item_cat_id,$brand_id);
         $data_array=array();
         foreach($product_list as $pd){
             $nested_array=array();
             $nested_array[]=$pd['product_code'];
             $nested_array[]=$pd['product_name'];
             $is_update=0;
             foreach($price_list as $m){
                 if($m['product_id']==$pd['product_id']){
                     if($m['is_updated']==1){
                        $is_update=1; 
                     }
                     $nested_array[]='<input name="Price_type_'.$m['price_type_id'].'" id="Price_type_'.$m['price_type_id'].$m['product_id'].'" value="'.$m['value'].'" >
                     <input type="hidden" name="product_id" id="product_id" value="'.$m['product_id'].'" readonly>
                     <input type="hidden" name="mstr_id" id="mstr_id" value="'.$last_id.'" readonly>';
                 }
             }
             if($is_update==1){
                 $status='<span class="btn btn-xs btn-success"><i class="fa fa-check"></i></span>';
             }else{
                 $status='<span class="btn btn-xs btn-warning"><i class="fa fa-warning"></i></span>';
             }
             
             $nested_array[]='<span id="updt_'.$pd['product_id'].'">'.$status.'</span><button style="display: none;" class="btn btn-default btn-sm" type="submit"><i class="fa fa-edit"></i> UPDATE</button>'; 
             $data_array[]=$nested_array;
         }
		 $data['data_list']=$data_array;
		}else{
		 $data['status']=0; 
		 $data['data_list']=array();
		}
	    $this->load->view('administration/price/new_price_list',$data);
    }
    
    function update_product_price(){
	    $this->load->library('form_validation');
		$this->form_validation->set_rules('mstr_id', 'ID', 'required|xss_clean');
		if ($this->form_validation->run() == FALSE)
        {
           $st = array('status' =>0,'validation' => validation_errors());
           echo json_encode($st);
        }
        else{
            $retail_price=$this->input->post('Price_type_1');
            $credit_price=$this->input->post('Price_type_2'); 
            $whole_sale_pice=$this->input->post('Price_type_3'); 
            $retail_wholesale_price=$this->input->post('Price_type_4');
            $product_id=$this->input->post('product_id');
		    $id=$this->input->post('mstr_id');
		    
		    $price_type_id=1;
		    $data=array(
                'value'=>$retail_price,
                'is_updated'=>1
                );
                $this->Price_Model->update_price_item($data,$product_id,$id,$price_type_id);
            $price_type_id=2;
		    $data=array(
                'value'=>$credit_price,
                'is_updated'=>1
                );
                $this->Price_Model->update_price_item($data,$product_id,$id,$price_type_id);
            $price_type_id=3;
		    $data=array(
                'value'=>$whole_sale_pice,
                'is_updated'=>1
                );
                $this->Price_Model->update_price_item($data,$product_id,$id,$price_type_id);
            $price_type_id=4;
		    $data=array(
                'value'=>$retail_wholesale_price,
                'is_updated'=>1
                );
                $this->Price_Model->update_price_item($data,$product_id,$id,$price_type_id);
           $st = array('status' =>1,'validation' => 'UPDATED','row_id'=>'#updt_'.$product_id);
           echo json_encode($st);
        }
        }
    
    public function create_new_prodcut_price_list(){
        /* create new recode for price  sachith eranga 2022-07-16 */
        $this->load->library('form_validation');	
        	$this->form_validation->set_rules('id', 'ID', 'required|xss_clean');
		 if ($this->form_validation->run() == FALSE)
        {
           $st = array('status' =>0,'validation' => validation_errors());
           echo json_encode($st);
        }
        else
        {
          /* get pending price list for availility check */
          $recode_count=$this->Price_Model->get_pending_price_list_count();
            if($recode_count>0){
                $st = array('status' =>0,'validation' => 'Already Availble');
                echo json_encode($st);
                return false;
            }
        $products=$this->Price_Model->get_prodcut_list();
        
         $data=array(
                'prm_ref_no'=>$this->common_model->gen_ref_number('prm_id','price_master','DPR'),
                'added_user_id'=>$this->session->userdata('ss_user_id'),
			    'added_date_time'=>date("Y-m-d H:i:s"),
                );
        $mstr_id=$this->Price_Model->save_price_master($data);
        foreach($products as $p){
            $data=array(
                'price_type_id'=>1,
                'product_id'=>$p['product_id'],
                'value'=>$p['product_price'],
                'prm_id'=>$mstr_id,
                );
                $this->Price_Model->save_price_item($data);
             $data=array(
                'price_type_id'=>2,
                'product_id'=>$p['product_id'],
                'value'=>$p['credit_salling_price'],
                'prm_id'=>$mstr_id,
                );
                $this->Price_Model->save_price_item($data);
             $data=array(
                'price_type_id'=>3,
                'product_id'=>$p['product_id'],
                'value'=>$p['wholesale_price'],
                'prm_id'=>$mstr_id,
                );
                $this->Price_Model->save_price_item($data);
                $data=array(
                'price_type_id'=>4,
                'product_id'=>$p['product_id'],
                'value'=>$p['retail_wholesale'],
                'prm_id'=>$mstr_id,
                );
                $this->Price_Model->save_price_item($data);
        }
         $st = array('status' =>1,'validation' => 'Saved');
                echo json_encode($st);
		}
    }
    
    public function price_list_approval(){
        $data['main_menu_name'] = 'products';
		$data['sub_menu_name'] = 'price_list_approval';
		$this->load->view('management/prining_list_approval',$data);
        
    }
    
    	public function get_price_approval_list($value = ''){
        $search_key     = $this->input->get('search');
        $search_key_val = $search_key['value'];
        $start          = $this->input->get('start');
        $length         = $this->input->get('length');
        $totalData      = 0;
        $values         = $this->Price_Model->get_price_list($start, $length, $search_key_val);
        $value_count    = $this->Price_Model->get_price_list('', '', '');
        if ($search_key_val) {
            $values_c  = $this->Price_Model->get_price_list('', '', $search_key_val);
            $totalData = 100;  
        }
        $totalData     = $value_count;
        $totalFiltered = $totalData;
     
        $data          = array();
        if (!empty($values)) {
            foreach ($values as $products) {
                $row=array();
                $row[]               = $products->added_date_time;
                $row[]               = $products->prm_ref_no;
                $row[]               = $products->mas_name;
                $row[]               = $products->added_user_first_name." ".$products->added_user_last_name;
                $row[]               = $products->approval_user_first_name." ".$products->approval_user_last_name;
                $row[]               = $products->approval_date_time;//$products->brm_note;
                $actdes = '';
                
                $approval_option='';
              if($products->aproval_status==0){
                   $update_action='<li><a href="' . base_url('price_adminstration/new_product_price') . '?id=' . $products->prm_id . '" target="_blank"><i class="fa fa-pencil-square-o"></i> VIEW OR UPDATE</a></li>';
                   
                   $approval_option='<li><a style="cursor: pointer;" onclick="approval_requste('. $products->prm_id .')"><i class="glyphicon fa fa-check"></i> APPROVAL</a></li>
                            <li><a style="cursor: pointer;" onclick="reject_request('. $products->prm_id .')"><i class="glyphicon fa fa-ban"></i> REJECT</a></li>';
                }else{
                    $update_action='';
                }
                $actdes = $actdes . '<div class="btn-group text-left">
                            <button data-toggle="dropdown" class="btn btn-default btn-xs  dropdown-toggle" type="button">Actions <span class="caret"></span></button>
                            <ul role="menu" class="dropdown-menu pull-right">
                            '.$update_action.$approval_option.'
                            
                            ';
                $row[]               = $actdes;
                $data[] = $row;
            }
            $output = array(
                'data' => $data,
                "recordsTotal" => intval($totalData),
                "recordsFiltered" => intval($totalFiltered)
            );
            echo json_encode($output);
        } else {
            $output = array(
                'data' => ''
            );
            echo json_encode($output);
        }
    }
    
   function  approval_price_list(){
       
        $this->load->library('form_validation');
		$this->form_validation->set_rules('id', 'ID', 'required|xss_clean');
		if ($this->form_validation->run() == FALSE)
        {
           $st = array('status' =>0,'validation' => validation_errors());
           echo json_encode($st);
        }
        else{
            $id= $this->input->post('id');
            $price_list=$this->Price_Model->get_price_item_list($id);
            foreach($price_list as $pl){
                if($pl['price_type_id']==1){
                     $data=array(
                    'product_price'=>$pl['value'],
                );
                $this->Price_Model->update_product($data,$pl['product_id']);
                $this->Price_Model->update_batch_product_table($data,$pl['product_id']);
                
                }
                if($pl['price_type_id']==2){
                     $data=array(
                    'credit_salling_price'=>$pl['value'],
                );
               $this->Price_Model->update_product($data,$pl['product_id']);
               $this->Price_Model->update_batch_product_table($data,$pl['product_id']);
                }
                if($pl['price_type_id']==3){
                     $data=array(
                    'wholesale_price'=>$pl['value'],
                    );
                $this->Price_Model->update_product($data,$pl['product_id']);
                $this->Price_Model->update_batch_product_table($data,$pl['product_id']);
                }
                if($pl['price_type_id']==4){
                     $data=array(
                    'retail_wholesale'=>$pl['value'],
                    );
                $this->Price_Model->update_product($data,$pl['product_id']);
                  $this->Price_Model->update_batch_product_table($data,$pl['product_id']);
                }
             }
              $data=array(
                    'aproval_status'=>1,
                    'approval_by'=>$this->session->userdata('ss_user_id'),
                    'approval_date_time'=>date("Y-m-d H:i:s"),
                    );
                   $this->Price_Model->update_price_master($data,$id);
                   $this->Sys_Settings_Model->enable_sys_setting(1);
                     $st = array('status' =>1,'validation' => 'Saved');
                echo json_encode($st);
        }
   }
    
     public function get_category_dynamic(){
        $str = $this->input->post('search_string');
		$result=$this->Price_Model->get_search_category($str);
        echo json_encode($result);
    }
    public function get_item_category_dynamic(){
        $str = $this->input->post('search_string');
        $cat_id = $this->input->post('cat_id');
        if(!$cat_id){
            $cat_id=0;
        }
		$result=$this->Price_Model->get_search_item_category($str,$cat_id);
        echo json_encode($result);
    }

   public function get_brand_dynamic(){
        $str = $this->input->post('search_string');
		$result=$this->Price_Model->get_search_brand($str);
        echo json_encode($result);
    }
   
   
  
}