<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Free_Issue_Process extends CI_Controller {
	
    var $main_menu_name = "free_issue_process";
	  var $sub_menu_name = "free_issue_process";

      function __construct() 
      {
        parent::__construct();
        $this->load->model('Free_Issue_Process_Model');
        $this->load->model('Common_Model');
		$this->load->model('Sequerty_Model');
        $this->load->library('form_validation');
		$this->load->model('User_Model');
      }
    public function index($e=0)
    {
      $data['error'] = $e;
      $data['main_menu_name'] = $this->main_menu_name;
      $data['sub_menu_name'] = "batch";
      $this->load->view('batch/batch_purchases_list',$data);
    }
    	public function add_new_free_issue_block()
	{
        $data['id'] = 1;
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = 'add_new_free_issue_block';
		
        if (isset($_GET['product_id'])) {
			$product_id=$_GET['product_id'];
		}
		else {
			$product_id='';
		}
		if($product_id){
			$data['product_id']=$product_id;
			$data['type']='A';
			$data['pageName']='CREATE FREE ISSUE';
			$data['btnText']='CREATE FREE ISSUE';
		}
        $this->load->view('product_free_issue/create_free_issue',$data);	
	}
	 public function save_free_product()
	{
	  
	    $this->load->library('form_validation'); //form validation lib
		$this->form_validation->set_rules('product_id', 'Product', 'required');
		$type=$this->input->post('type');
		$price_type=$this->input->post('price_type');
		$product_id=$this->input->post('product_id');
		$cost=$this->input->post('cost');
		$start_qty=$this->input->post('start_qty');
		$end_qty=$this->input->post('end_qty');
		$free_qty=$this->input->post('free_qty');
		if ($this->form_validation->run() == FALSE)
        {
           $st = array('status' =>0,'validation' => validation_errors());
           echo json_encode($st);
        }
        else
        {
		$data=array(
			'price_type'=>$price_type,
			'product_id'=>$product_id,
			'start_req_qty'=>$start_qty,	
			'end_req_qty'=>$end_qty,
			'free_qty'=>$free_qty,
			'product_cost'=>$cost,
			'user_id'=>$this->session->userdata('ss_user_id'),
			'date_time'=>date("Y-m-d H:i:s"),
			
		);
		$result=$this->Free_Issue_Process_Model->save_free_product($data);
		$lastid=$this->db->insert_id();
		if($type=='A'){
			if ($lastid) {
				echo json_encode(array('id'=>$lastid,'type'=>$type,'status' =>1));
			} else {
				echo json_encode(array('status'=>'0'));
			}
		}
		if($type=='E'){
			echo json_encode(array('type'=>$type,'status' =>1));
		}	
		}
	}
	public function update_free_issue_product()
	{
	    $id=$this->input->get('id');
	    $data=array(
			'is_deleted'=>1,
		);
		$result=$this->Free_Issue_Process_Model->update_free_issue_product($data,$id);
			if($result==1){
				echo json_encode(array('id'=>'','status' =>1,'message'=>"Done"));
			} else {
			   echo json_encode(array('id'=>'','status' =>0,'message'=>"Fail"));
			}
	}
	public function update_free_issue_block()
	{
        $data['id'] = 1;
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = 'add_new_free_issue_block';
		
        if (isset($_GET['free_issue_id'])) {
			$free_issue_id=$_GET['free_issue_id'];
		}
		else {
			$free_issue_id='';
		}
		if($free_issue_id){
			$data['free_issue_id']=$free_issue_id;
			$data['type']='A';
			$data['pageName']='EDIT FREE ISSUE';
			$data['btnText']='EDIT FREE ISSUE';
			$data['details']= $this->Free_Issue_Process_Model->get_free_issue_details($free_issue_id);	
		}
        $this->load->view('product_free_issue/update_free_issue',$data);	
	}
	 public function update_free_product()
	{
	    $this->load->library('form_validation'); //form validation lib
		$this->form_validation->set_rules('free_issue_id', 'Product', 'required');
		$type=$this->input->post('type');
		$price_type=$this->input->post('price_type');
		$product_id=$this->input->post('product_id');
		$cost=$this->input->post('cost');
		$start_qty=$this->input->post('start_qty');
		$end_qty=$this->input->post('end_qty');
		$free_qty=$this->input->post('free_qty');
		$free_issue_id=$this->input->post('free_issue_id');
		
		if ($this->form_validation->run() == FALSE)
        {
           $st = array('status' =>0,'validation' => validation_errors());
           echo json_encode($st);
        }
        else
        {
		$data=array(
			'price_type'=>$price_type,
			'product_id'=>$product_id,
			'start_req_qty'=>$start_qty,	
			'end_req_qty'=>$end_qty,
			'free_qty'=>$free_qty,
			'product_cost'=>$cost,
			'user_id'=>$this->session->userdata('ss_user_id'),
			'date_time'=>date("Y-m-d H:i:s"),
			
		);
		$result=$this->Free_Issue_Process_Model->update_free_issue_product($data,$free_issue_id);
		if($type=='A'){
			if ($result==1) {
				echo json_encode(array('id'=>0,'type'=>$type,'status' =>1));
			} else {
				echo json_encode(array('status'=>'0'));
			}
		}
		if($type=='E'){
			echo json_encode(array('type'=>$type,'status' =>1));
		}	
		}
	}
	
	

	


}