<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Orders_model extends CI_Model {
  
  private $tableName = 'orders';
  
  function __construct() 
  {
    /* Call the Model constructor */
    parent::__construct();
  }
  
  public function get_all_orders_del(){
      $this->db->select('o.*,oc.*,os.*');
		$this->db->from('orders o');
		$this->db->join('orders_customer oc', 'oc.order_reference_id = o.order_reference_id', 'left');
                $this->db->join('order_status os', 'os.status_id = o.order_status', 'left');
		
		$this->db->order_by("o.order_id", "asc");
//		$this->db->where("o.exp_id IS NOT NULL");//("id !=",$id);
		$query = $this->db->get();
		return $query->result_array();
  }
  
  public function get_all_mstr_order_status(){
      $this->db->select('mos.*');
		$this->db->from('mstr_order_status mos');
		$this->db->order_by("mos.status_id", "asc");
//		$this->db->where("o.exp_id IS NOT NULL");//("id !=",$id);
		$query = $this->db->get();
		return $query->result_array();
  }
  
   public function get_all_orders(){
      $this->db->select('oc.*,c.*,mos.*');
		$this->db->from('order_customer oc');
		$this->db->join('customer c', 'oc.customer_id = c.cus_id', 'left');
         $this->db->join('mstr_order_status mos', 'oc.order_status = mos.status_id', 'left');
		
		$this->db->order_by("oc.ord_cus_id", "desc");
//		$this->db->where("o.exp_id IS NOT NULL");//("id !=",$id);
		$query = $this->db->get();
		return $query->result_array();
  }
  
  public function get_order_by_id($ord_cus_id = ""){
     $this->db->select('oc.*,c.*');
     $this->db->from('order_customer oc');
     $this->db->join('customer c', 'oc.customer_id = c.cus_id', 'left');
         $this->db->join('mstr_order_status mos', 'oc.order_approval_status = mos.status_id', 'left');
		  $this->db->where('oc.ord_cus_id',$ord_cus_id);
     $query = $this->db->get();  
     if($query->num_rows() >0)
     {
       return $query->row();
     }
     else
     {
       return false;
     }
  }
  
  public function get_order_by_order_id($order_id = ""){
      $this->db->select('o.*, oc.*');
     $this->db->from('orders o');
     $this->db->join('orders_customer oc','oc.order_reference_id = o.order_reference_id','left');
     $this->db->where('o.order_id',$order_id);
     $query = $this->db->get();  
     if($query->num_rows() >0)
     {
       return $query->row();
     }
     else
     {
       return false;
     }
  }
  
  public function get_order_items($order_cus_id = ""){
      $this->db->select("oci.*,p.*");
     $this->db->from("order_customer_item oci");
	 $this->db->join('product p','oci.product_id = p.product_id','left');
     $this->db->where("oci.order_cus_id",$order_cus_id);
	 
     $query = $this->db->get();  
     
    
     if($query->num_rows() >0)
     {
       return $query->result();
     }
     else
     {
       return false;
     }
  }
  
  function save_orders(&$supplier_data,$ord_cus_id=false)
	{
		if (!$ord_cus_id)
		{
			$this->db->insert('order_customer',$supplier_data);
		}else {
			$this->db->where('ord_cus_id', $ord_cus_id);
			return $this->db->update('order_customer',$supplier_data);
		}
	}
  
  public function get_order_items_by_order_id($order_id = ""){
      $this->db->select("oci.*,p.*,oc.*");
     $this->db->from("order_customer_item oci");
	  $this->db->join('order_customer oc','oci.order_cus_id = oc.ord_cus_id','left');
	  $this->db->join('product p','oci.product_id = p.product_id','left');
     $this->db->where("oci.order_cus_id",$order_id);
     $query = $this->db->get();  
	// echo $this->db->last_query();
     if($query->num_rows() >0)
     {
       return $query->result_array();
     }
     else
     {
       return false;
     }
  }
  
  public function change_status($status){
      $this->db->set('order_status', $status);
      $flag = $this->db->update('orders');
      return $flag;
  }
  
  
  function get_order_avalable_product_qty_for_pack($product_id,$ord_cus_id){
		$this->db->select_sum('oci.product_qty');
		//$this->db->where("fi.fi_type_id", 'sale');
		$this->db->from('order_customer_item oci');
		$this->db->join('order_customer oc', "oci.order_cus_id = oc.ord_cus_id", 'left');
		$this->db->where("oci.product_id", $product_id);
		$this->db->where("oci.order_cus_id", $ord_cus_id);
		$this->db->where("oc.order_status", 2);
		
		$query = $this->db->get();
		//echo $this->db->last_query();
		return $query->row()->product_qty;
	}
	
	//Sales return get get product qty
	function get_order_packed_product_qty($product_id,$ord_cus_id){
		$this->db->select_sum('si.quantity');
		$this->db->from('sale_items si');
		$this->db->join('sales s', "si.sale_id = s.sale_id", 'left');
		//$this->db->where("r.warehouse_id", $warehouse_id);
		$this->db->where("s.ord_cus_id", $ord_cus_id);
		$query = $this->db->get();
		//echo $this->db->last_query();
		return $query->row()->quantity;
	}
	
	function get_order_product_qty($product_id,$ord_cus_id){
		$this->db->select_sum('oci.product_qty');
		$this->db->from('order_customer_item oci');
		//$this->db->join('sales s', "si.sale_id = s.sale_id", 'left');
		//$this->db->where("r.warehouse_id", $warehouse_id);
		$this->db->where("oci.order_cus_id", $ord_cus_id);
		$query = $this->db->get();
		//echo $this->db->last_query();
		return $query->row()->product_qty;
	}

}