<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Department_Model extends CI_Model {

    private $tableName = 'mstr_department';

    function __construct()
    {
        /* Call the Model constructor */
        parent::__construct();
    }

    function save_department(&$department_data,$department_id=false)
    {
        if (!$department_id)
        {
            $this->db->insert($this->tableName,$department_data);
        }else {
            $this->db->where('department_id', $department_id);
            return $this->db->update($this->tableName,$department_data);
        }
    }
    
    function get_all_type_list() {
        $this->db->select('mstr_pro_type'.'.*');
        $this->db->order_by("ptype_name", "asc");
        //$this->db->where("department_id IS NOT NULL");//("id !=",$id);
        $query = $this->db->get('mstr_pro_type');
        return $query->result();
    }
    
    function get_all_department_list() {
        $this->db->select($this->tableName.'.*');
        $this->db->order_by("department_id", "desc");
        $this->db->where("department_id IS NOT NULL");//("id !=",$id);
        $query = $this->db->get($this->tableName);
        return $query->result();
    }
    function get_all_department() {
        $this->db->select($this->tableName.'.*');
        $this->db->order_by("department_id", "desc");
        $this->db->where("department_id IS NOT NULL");//("id !=",$id);
        $query = $this->db->get($this->tableName);
        return $query->result_array();
    }

    public function get_department_info($id)
    {
        $this->db->select('*');
        $this->db->from($this->tableName);
        $this->db->where("department_id", $id);
        $this->db->order_by("department_id", "desc");
        $query = $this->db->get();

        return $query->row_array();
    }

    public function delete_department($department_id)
    {
        $this->db->where('department_id', $department_id);
        $this->db->delete($this->tableName);

    }

    public function disable_department($department_id)
    {
        $data = array(
            'department_status' => 0
        );
        $this->db->where('department_id', $department_id);
        $this->db->update($this->tableName, $data);
    }

    public function enable_department($department_id)
    {
        $data = array(
            'department_status' => 1
        );
        $this->db->where('department_id', $department_id);
        $this->db->update($this->tableName, $data);
    }
}