<?php
defined('BASEPATH') OR exit('No direct script access allowed');


class Cart extends CI_Controller {



    function __construct() {

        parent::__construct();

        $this->load->helper('url');
        $this->load->model('product_model');
        $this->load->library('cart');
        $this->load->library('session');
        $this->load->model('Cart_Model');
        $this->load->model('User_Model');
        $this->load->model('Home_Model');
        $this->load->helper('security');
    }
    
    public function index(){
		
		$bodyClass = "page-template-default";
		$data['bodyClass'] =$bodyClass;	
		$data['cart'] = $this->cart->contents();
		$data['cart_count'] =count($data['cart'] );
        $data['cart_total'] = $this->cart->total();	        
        $cus_id=$this -> session -> userdata('site_cus');
        $data['destination'] ="cart/checkOut";
        $data['sub_category_list'] = $this->Home_Model->get_sub_category_for_homepage();
		$data['category_list'] = $this->Home_Model->get_category_for_homepage(); 

        if(isset($cus_id)){$data['destination'] ="cart/checkOut";}else{$data['destination'] ="users/userLoginSingup";}

        $this->load->view('cart/cart' , $data);

    }
    
    public function addtocart() {
        $product_id = $this->input->post('pro_id');
        $quantity = $this->input->post('pro_qty');
        $product_details = $this->product_model->get_single_product($product_id);	       
        $cart_data = array(
            'id' => $product_id,
            'name' => $product_details['product_name'],
            'price' => $product_details['product_price'],
            'image' => $product_details['product_thumb'],
            'qty' => $quantity,
            'item_cost' => $product_details['product_cost'],
            'discount'=>  $product_details['discount_value'], 
        );
        $status = $this->cart->insert($cart_data);       
        $data['message'] = "Item added to Cart";
		echo json_encode($data);
    }
	
	 public function remove_cart() {
        $rowid = $this->input->post('pro_id');
        if ($rowid === "all") {
            // Destroy data which store in session.
            $data = array();
            $this->cart->destroy();
        } else {
            // Destroy selected rowid in session.
            $data = array(
                'rowid' => $rowid,
                'qty' => 0
            ); // Update cart data, after cancel.
            $status = $this->cart->update($data);
            //$data = $this->cart_count();            
            //$data['cart'] = $this->cart->contents();
			$data['message'] = "Item Remove From Cart";
        }
        echo json_encode($data);
    }
    
    
    public function update_cart() {
        $rowid = $this->input->post('pro_id');
        $qty = $this->input->post('qty');        
            // update selected rowid in session.
            $data = array(
                'rowid' => $rowid,
                'qty' => $qty
            ); // Update cart data, after cancel.
            $status = $this->cart->update($data);
            
			$data['message'] = "Item updated to Cart";       
        echo json_encode($data);
    }	

    
	 public function view_cart() {        
        $data['message'] = $this->cart->total();//$this->cart_count();
		print_r($data['message'] );
        echo json_encode($data);
    }

    function checkOut()
    {
        $bodyClass = "page-template-default";
		$data['bodyClass'] =$bodyClass;	
		$data['cart'] = $this->cart->contents();
		$data['cart_count'] =count($data['cart'] );
        $data['cart_total'] = $this->cart->total();	        
        $data['sub_category_list'] = $this->Home_Model->get_sub_category_for_homepage();
		$data['category_list'] = $this->Home_Model->get_category_for_homepage(); 
        $cus_id=$this -> session -> userdata('site_cus');
        if(isset($cus_id)){
            $data['cus_data'] = $this->User_Model->get_customer_details($cus_id); 

        if($data['cus_data']['is_confirm']==1){
            $data['city_list'] = $this->User_Model->get_cities(); 
            $this->load->view('cart/checkout' , $data);
        }else{
            ob_start();
            header('Location: '.base_url('users/confirmAccount'));
            ob_end_flush();
            die();
        }    
        }else
        {
            ob_start();
            header('Location: '.base_url('users/userLoginSingup'));
            ob_end_flush();
            die();
        }     
    }


    function place_order(){

        $redirect="cart/orderCompleted";
        $this->load->library('form_validation'); //form validation lib		
		//validations
		
        $this->form_validation->set_rules('billing_first_name', 'First Name', 'trim|required|min_length[3]|max_length[255]|xss_clean');
        $this->form_validation->set_rules('billing_last_name', 'Last Name', 'trim|required|min_length[3]|max_length[255]|xss_clean');
        $this->form_validation->set_rules('billing_company', 'Company', 'trim|max_length[255]|xss_clean');
        $this->form_validation->set_rules('billing_country', 'Country', 'trim|required|xss_clean');
        $this->form_validation->set_rules('billing_address_1', 'Address', 'trim|required|min_length[3]|max_length[500]|xss_clean');
        $this->form_validation->set_rules('billing_address_2', 'Apartment , Site , Unit', 'trim|max_length[500]|xss_clean');
        $this->form_validation->set_rules('billing_city', 'City', 'trim|required|xss_clean');
        $this->form_validation->set_rules('billing_postcode', 'ZIP code', 'trim|required|min_length[3]|max_length[20]|xss_clean');
        $this->form_validation->set_rules('billing_phone', 'Mobile', 'trim|required|min_length[10]|max_length[15]|xss_clean');
        $this->form_validation->set_rules('billing_email', 'Email', 'trim|required|min_length[3]|max_length[100]|xss_clean');
        $this->form_validation->set_rules('ship_to_different_address', 'Diffarant Address', 'trim|xss_clean');
        $this->form_validation->set_rules('terms', 'trems', 'trim|xss_clean');    
        $this->form_validation->set_rules('payment_method', 'Payment Methord', 'trim|required|xss_clean');
        $this->form_validation->set_rules('terms-field', 'Term Field', 'trim|required|xss_clean'); 
        $this->form_validation->set_rules('order_comments', 'Commente', 'trim|max_length[500]|xss_clean');   

        $ship_to_different_address=$this->input->post('ship_to_different_address');
        if($ship_to_different_address==1){
        $this->form_validation->set_rules('shipping_first_name', 'First Name', 'trim|required|min_length[3]|max_length[255]|xss_clean');
        $this->form_validation->set_rules('shipping_last_name', 'Last Name', 'trim|required|min_length[3]|max_length[255]|xss_clean');
        $this->form_validation->set_rules('shipping_company', 'Company', 'trim|xss_clean');
        $this->form_validation->set_rules('shipping_country', 'Country', 'trim|required|xss_clean');
        $this->form_validation->set_rules('shipping_address_1', 'Address', 'trim|required|min_length[3]|max_length[500]|xss_clean');
        $this->form_validation->set_rules('shipping_address_2', 'Address 2', 'trim|max_length[500]|xss_clean');
        $this->form_validation->set_rules('shipping_city', 'City', 'trim|required|xss_clean');
        $this->form_validation->set_rules('shipping_state', 'State', 'trim|required|xss_clean');
        $this->form_validation->set_rules('shipping_postcode', 'ZIP code', 'trim|required|min_length[3]|max_length[20]|xss_clean');       
        
        }
        //check validation	
		 if ($this->form_validation->run() == FALSE)
        {
           $st = array('status' =>0,'message' => validation_errors());
           echo json_encode($st);
        }
        else
        {
            $status=1;            
            $message="fist step ok";            
            $terms_field=$this->input->post('terms');            
            if($terms_field=="on"){
            $status=1;            
            $message="term and condition accepted";
            $cart= $this->cart->contents();
            $cart_count =count($cart );            
            if($cart_count>0){
                $status=1;            
                $message="term and condition accepted";
                }else{
                    $status=0;            
                    $message="Your Cart is empty!";
                }
            }else{
                $status=0;            
                $message="please accept the terms & conditions";
            }          
            $billing_first_name=$this->input->post('billing_first_name');
		    $billing_last_name=$this->input->post('billing_last_name');
            $billing_company=$this->input->post('billing_company');
            $billing_country=$this->input->post('billing_country');
            $billing_address_1=$this->input->post('billing_address_1');
            $billing_address_2=$this->input->post('billing_address_2');
            $billing_city=$this->input->post('billing_city');  
            $billing_postcode=$this->input->post('billing_postcode');  
            $billing_phone=$this->input->post('billing_phone');  
            $billing_email=$this->input->post('billing_email');  
            $payment_method=$this->input->post('payment_method');            
            $cus_id=$this -> session -> userdata('site_cus');            

            if($cus_id>0){
                if($status==1){
                    $cart = $this->cart->contents();
                    $cart_total = $this->cart->total();	
                    $qty_total=0;
                    $total_cost=0;
                    foreach($cart as $ca ){
                        $qty_total+= $ca['qty'];
                        $total_cost+=$ca['item_cost']*$ca['qty'];
                    }
                    $temp="";
                    $code=$this->Cart_Model->gen_code('ord_cus_id','order_customer','ODR'); 
                    $order_master_data=array(
                        'order_reference'=>$code,
                        'order_date'=>date("Y-m-d"),
                        'customer_id'=>$cus_id,
                        'order_type_id'=>1,
                        'payment_type'=>$payment_method,
                        'total_order_value'=>$cart_total,
                        'shipping_cost'=>0,
                        'addtional_cost'=>0,
                        'total_tax_value'=>0,
                        'order_cost'=>$total_cost,
                        'order_status'=>1,
                        'order_payment_status'=>1,
                        'order_approval_status'=>1,                    
                    );
                    $result=$this->Cart_Model->save_order_master($order_master_data); 
                    if($result==0){
                    $status=0;
                    $message="Somthing worng while place the order. please try again!";
                    }else{
                        $master_id=$result;
                        foreach($cart as $ca ){
                            $order_item_data=array(
                                'order_cus_id'=>$master_id,
                                'product_id'=>$ca['id'],
                                'product_price'=>$ca['price'],
                                'product_cost'=>$ca['item_cost'],
                                'product_qty'=>$ca['qty'],
                                'total_gross_value'=>$ca['subtotal'],
                                'total_cost_value'=>$ca['item_cost']*$ca['qty'],
                                'total_net_value'=>$ca['subtotal'],                                             
                            );
                            $result=$this->Cart_Model->save_order_item($order_item_data); 
                            if($result==0){
                                $status=0;
                                $message="Somthing worng while place the order. please try again!";
                                }else{
                                    $status=1;
                                    $message="Order placed . Thank You";
                                    if($payment_method==4){
                                        $redirect="cart/payment?odr_id=".$master_id;
                                    }else{
                                        $redirect="cart/orderCompleted?odr_id=".$master_id;
                                    }
                                } 
                        }
                    }
                }else{

                }               
            }else{
                $status=0;            
                $message="Logging Timeout. Please login again!";  
            } 

            if($status==1){
                $data = array();
                $this->cart->destroy();
            }          
           
            $st = array('status' =>$status,'message' => $message,'direction'=>$redirect) ;
            echo json_encode($st);
        }
    }


    function orderCompleted()
    {
        $order_id=$this->input->get('odr_id'); 
        $bodyClass = "page home page-template-defaul";
		$data['bodyClass'] =$bodyClass;	
		$data['cart'] = $this->cart->contents();
		$data['cart_count'] =count($data['cart'] );
        $data['cart_total'] = $this->cart->total();	        
        $data['sub_category_list'] = $this->Home_Model->get_sub_category_for_homepage();
        $data['category_list'] = $this->Home_Model->get_category_for_homepage(); 
        $cus_id=$this -> session -> userdata('site_cus');
        if(isset($cus_id)){
            $data['cus_data'] = $this->User_Model->get_customer_details($cus_id); 

        if($data['cus_data']['is_confirm']==1){

            $data['order_master_data'] = $this->Cart_Model->get_order_details($order_id); 
            $data['order_item_data'] = $this->Cart_Model->get_order_item_details($order_id); 
            $data['order_tracking'] = $this->User_Model->get_order_tracking_details($order_id);

             $this->load->view('cart/order-success' , $data);
        }else{
            ob_start();
            header('Location: '.base_url('users/confirmAccount'));
            ob_end_flush();
            die();
        }    
        }else
        {
            ob_start();
            header('Location: '.base_url('users/userLoginSingup'));
            ob_end_flush();
            die();
        }
    }


    function payment()
    {
        $order_id=$this->input->get('odr_id'); 
        $bodyClass = "my-account woocommerce-active left-sidebar";
		$data['bodyClass'] =$bodyClass;	
		$data['cart'] = $this->cart->contents();
		$data['cart_count'] =count($data['cart'] );
        $data['cart_total'] = $this->cart->total();	        
        $data['sub_category_list'] = $this->Home_Model->get_sub_category_for_homepage();
        $data['category_list'] = $this->Home_Model->get_category_for_homepage(); 
        $cus_id=$this -> session -> userdata('site_cus');
        if(isset($cus_id)){
            $data['cus_data'] = $this->User_Model->get_customer_details($cus_id); 

        if($data['cus_data']['is_confirm']==1){

            $data['order_master_data'] = $this->Cart_Model->get_order_details($order_id); 
            $data['order_item_data'] = $this->Cart_Model->get_order_item_details($order_id); 

             $this->load->view('cart/my-payment-details' , $data);
        }else{
            ob_start();
            header('Location: '.base_url('users/confirmAccount'));
            ob_end_flush();
            die();
        }    
        }else
        {
            ob_start();
            header('Location: '.base_url('users/userLoginSingup'));
            ob_end_flush();
            die();
        }
    }
	
	
	
	
	
    //old implementation-----------------------------------------------------------------------------------------------
    
    
    public function cart_count(){
        $data['cart'] = $this->cart->contents();
        $cart = $this->cart->contents();
        $total_cart = 0;
        foreach ($cart as $cart) {
            $total_cart = $total_cart + $cart['subtotal'];
        }
        $data['sub_total'] = $total_cart;
        $data['cart_count'] = count($this->cart->contents());
        $data['delivery_charge'] = 0;
        $data['discount'] = 0;
        $data['grand_total'] = $total_cart;
        return $data;
    }

    
   
    
   
    
    public function delivery_method(){
        if(is_logged_in()){
        $data = $this->cart_count();
        $data['cities'] = $this->cart_model->get_cities();
        $this->load->view('cart/ship_method' , $data);
        }else{
            redirect(base_url().'Users?cart_user=yes');
        }
    }

    
   



    public function countinue_checkout() {

        $get_data = $this->session->userdata();



        if (isset($get_data['login_user']['is_login'])) {

            $data['url_go'] = base_url() . 'Cart/checkout';

        } else {

            $data['url_go'] = base_url() . "Users?cart_user=yes";

        }



        echo json_encode($data);

    }



    



    public function save_order() {

        date_default_timezone_set('Asia/Colombo');

        $cart = $this->cart->contents();

        if (count($cart) > 0) {

            $get_max = $this->cart_model->get_max_orderid();

            if (isset($get_max['order_reference_id'])) {

                $newstring = substr($get_max['order_reference_id'], -5);

                $order_id_last = $newstring + 1;

                $order_id = "SM" . sprintf('%05d', $order_id_last);

            } else {

                $order_id = "SM00001";

            }

            $get_data = $this->session->all_userdata();
            $grand_total = 0;

            foreach ($cart as $cart_res) {

                $grand_total = $grand_total + $cart_res['subtotal'];

            }
            $card = $this->return_card();
            $customer['fname'] = $this->input->post('firstName');
            $customer['lname'] = $this->input->post('lastName');
            $customer['address'] = $this->input->post('address');
            $customer['towncity'] = $this->input->post('towncity');
            $customer['email'] = $this->input->post('email');
            $customer['mobile'] = $this->input->post('phone');
            $customer['order_reference_id'] = $order_id;

            $order['order_reference_id'] = $order_id;
            $order['customer_id'] = "";
            $order['sale_total'] = $card['grand_total'];
            $order['payment_status'] = 'pending';
            $order['payment_method'] = $this->input->post('pay_method');
            $order['order_datetime'] = date("Y-m-d");
//        $order['payment_type'] = $this->input->post('payment_method');

            $status = $this->cart_model->save_order($customer, $order, $cart);
            if ($status) {
                
                if ($order['payment_method'] == 'OP') {

                    $data['red_url'] = base_url() . 'Cart/online_payment';

                    $cart_ses = array(
                        'orderid' => $order_id,
                    );
                    $this->session->set_userdata('order_data',$cart_ses);

                }else if($order['payment_method'] == 'cod'){
                    $this->session->unset_userdata('session_add_cart'); // destroy session
                    $this->cart->destroy();
//                    $data['red_url'] = base_url() . 'Cart/purchase_successfull?orderid='.$order_id;
                }
                
                
                
                $mes_con = array(
                'name' => $this->input->post('firstName'),
                    'order_id' => $order_id,
                'item_list' => $cart
            );
            $data_email = array(
                'email_name' => 'Opsel Malabe - Your Order Success',
                'toemail' => $this->input->post('email'),
                'subject' => 'Your Order Success.',
                'message' => $this->load->view('emails/order_customer' , $mes_con , TRUE)
            );
            $this->Emailer_model->send_mail($data_email);
            
            $mes_con_shop = array(
                    'order_id' => $order_id,
                'item_list' => $cart
            );
            $data_email_shop = array(
                'email_name' => 'Opsel Malabe - New Order',
                'toemail' => 'anttjayasinghe@gmail.com',
                'subject' => 'New Order Recieved',
                'message' => $this->load->view('emails/order_recieve' , $mes_con_shop , TRUE)
            );
            $this->Emailer_model->send_mail($data_email_shop);
            redirect(base_url() . 'Cart/purchase_successfull?orderid='.$order_id);
            } else {
                $data['red_url'] = "#";
            }
            $data['status'] = $status;

        }else{
            redirect(base_url() . 'Product/Shop');
        }


    }

    

    public function purchase_successfull(){

        $ord_id = $this->input->get('orderid');

        $result['order_data'] = $this->cart_model->get_order($ord_id);

        

        $this->load->view('cart/purchase_successfull' ,$result);

    }

            function return_card() {

        $cart = $this->cart->contents();

        $grand_total = 0;

        $sum = array();

        foreach ($cart as $cart_res) {

            $grand_total = $grand_total + $cart_res['subtotal'];

        }

        $sum['grand_total'] = $grand_total;

        $sum['cart_count'] = count($this->cart->contents());

        return $sum;

    }



    public function online_payment() {

        if(true){

            $get_data = $this->session->userdata();

            if(isset($get_data['order_data']['orderid'])){

            $order_id = $get_data['order_data']['orderid'];

            $order_idetails = $this->cart_model->get_order($order_id);

            $firstname=$order_idetails['fname'];

            $lastname=$order_idetails['lname'];

            $email=$order_idetails['email'];

            $phone=$order_idetails['mobile'];

            $address=$order_idetails['address'];

            $city=$order_idetails['towncity'];

            $amount=$order_idetails['sale_total'];

            $tanx_user_id=$order_idetails['ord_cus_id'];

            

            $url = 'https://www.payhere.lk/pay/checkout';

            $urlsand = 'https://sandbox.payhere.lk/pay/checkout';

            $html = "<html><body><form id='form' action='$urlsand' method='post'>";

            $html .= "<input type='hidden' name='merchant_id' value='1210465'>";

            $html .= "<input type='hidden' name='return_url' value='http://sampathtest.salleepos.com.lk/smarttest/shoppingcart2/'>";

            $html .= "<input type='hidden' name='cancel_url' value='http://sampathtest.salleepos.com.lk/smarttest/shoppingcart2/'>";

            $html .= "<input type='hidden' name='notify_url' value='http://sampathtest.salleepos.com.lk/smarttest/shoppingcart2/cart/update_online_tranx/'>";

            $html .= "<input type='hidden' name='first_name' value='$firstname'>";

            $html .= "<input type='hidden' name='last_name' value='$lastname'>";

            $html .= "<input type='hidden' name='email' value='$email'>";

            $html .= "<input type='hidden' name='phone' value='$phone'>";

            $html .= "<input type='hidden' name='address' value='$address'>";

            $html .= "<input type='hidden' name='city' value='$city'>";

            $html .= "<input type='hidden' name='country' value='sri lanka'>";

            $html .= "<input type='hidden' name='order_id' value='$order_id'>";

            $html .= "<input type='hidden' name='items' value='items'>";

            $html .= "<input type='hidden' name='currency' value='LKR'>";

            $html .= "<input type='hidden' name='amount' value='$amount'>";

            $html .= "<input type='hidden' name='custom_1' value='$tanx_user_id'>";

            $html .= "</form><script>document.getElementById('form').submit();</script>";

            $html .= "</body></html>";

            print($html);

//            $payhere = array(

//                'merchant_id' => '1210465',

//                'return_url' => 'http://jobspandora.com',

//                'cancel_url' => 'http://jobspandora.com',

//                'notify_url' => 'http://jobspandora.com',

//                'first_name' => $order_idetails['fname'],

//                'last_name' => $order_idetails['lname'],

//                'email' => $order_idetails['email'],

//                'phone' => $order_idetails['mobile'],

//                'address' => $order_idetails['address'],

//                'city' => $order_idetails['towncity'],

//                'country' => 'Sri Lanka',

//                'order_id' => $order_id,

//                'items' => '',

//                'currency' => 'LKR',

//                'recurrence' => '',

//                'duration' => '',

//                'amount' => $order_idetails['fname']

//            );

//            

//            $payhere = json_encode($payhere);

//            print_r($payhere);

//        $headers = array(

//            "Content-type: application/json;", //x-www-form-urlencoded

//            "Accept: text/html,application/xml;q=0.8",

//            "Cache-Control: no-cache",

//            "Pragma: no-cache",

//            "method: post",

//        );

//

//        $url = "https://sandbox.payhere.lk/pay/checkout";

//

//        $handle = curl_init();

//        curl_setopt($handle, CURLOPT_URL, $url);

//        curl_setopt($handle, CURLOPT_HTTPHEADER, $headers);

//        curl_setopt($handle, CURLOPT_RETURNTRANSFER, true);

//        curl_setopt($handle, CURLOPT_SSL_VERIFYHOST, false);

//        curl_setopt($handle, CURLOPT_SSL_VERIFYPEER, false);

//        curl_setopt($handle, CURLOPT_POST, true);

//        curl_setopt($handle, CURLOPT_POSTFIELDS, $payhere);

//        curl_setopt($handle, CURLOPT_VERBOSE, true);

//        } else {

//            redirect(base_url());

//        }

        }else{

            redirect(base_url());

        }

    }

    }

    

    public function update_cart_ajax(){

        $rowid = $this->input->post("rowid");

        $qty = $this->input->post("quantity");

        if(isset($rowid) && isset($qty) && $qty > 0 ){

            $data = array(

                'rowid' => $rowid,

                'qty' => $qty

            );

            $this->cart->update($data);

            $this->set_cart_session();

            $cart = $this->cart->contents();

            $product_total = 0;

            $total_cart = 0;

            foreach ($cart as $cart_res){

                $total_cart = $total_cart + $cart_res['subtotal'];

                if($rowid == $cart_res['rowid']){

                $product_total = $cart_res['subtotal'];

                }

            }

            $data['product_total'] = $product_total;

            $data['total_cart'] = $total_cart;

            $data['grand_total'] = $total_cart;

            $data['sucsess'] = 'yes';

        }else{

            $data['status'] = 'no';

        }

        

        echo json_encode($data);

    }

    

    function set_cart_session(){

        $cart = $this->cart->contents();

//        print_r($cart);

        $total_cart = 0;

        foreach ($cart as $cart) {

            $total_cart = $total_cart + $cart['subtotal'];

        }

        

            $data['cart_count'] = count($this->cart->contents());

            $data['grand_total'] = $total_cart;

            

            $this->session->set_userdata('session_add_cart',$data);

    }

    

    public function update_online_tranx(){

        echo 'ffff';

    }



}

